/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.core;

import io.advantageous.boon.core.Exceptions;
import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.reflection.FastStringUtils;
import io.advantageous.boon.primitive.CharScanner;
import io.advantageous.boon.primitive.Chr;

public class StringScanner {
    private static final char[] WHITE_SPACE = new char[]{'\n', '\t', ' ', '\r'};

    public static boolean isDigits(String input) {
        return CharScanner.isDigits(FastStringUtils.toCharArray(input));
    }

    public static String[] split(String string, char split, int limit) {
        char[][] comps = CharScanner.split(FastStringUtils.toCharArray(string), split, limit);
        return Str.fromCharArrayOfArrayToStringArray(comps);
    }

    public static String[] split(String string, char split) {
        char[][] comps = CharScanner.split(FastStringUtils.toCharArray(string), split);
        return Str.fromCharArrayOfArrayToStringArray(comps);
    }

    public static String[] splitByChars(String string, char ... delimiters) {
        char[][] comps = CharScanner.splitByChars(FastStringUtils.toCharArray(string), delimiters);
        return Str.fromCharArrayOfArrayToStringArray(comps);
    }

    public static String[] splitByCharsFromToDelims(String string, int from, int to, char ... delimiters) {
        char[][] comps = CharScanner.splitByCharsFromToDelims(FastStringUtils.toCharArray(string), from, to, delimiters);
        return Str.fromCharArrayOfArrayToStringArray(comps);
    }

    public static String[] splitByCharsFrom(String string, int from, char ... delimiters) {
        char[][] comps = CharScanner.splitByCharsFromToDelims(FastStringUtils.toCharArray(string), from, string.length(), delimiters);
        return Str.fromCharArrayOfArrayToStringArray(comps);
    }

    public static String[] splitByWhiteSpace(String string) {
        char[][] comps = CharScanner.splitByChars(FastStringUtils.toCharArray(string), WHITE_SPACE);
        return Str.fromCharArrayOfArrayToStringArray(comps);
    }

    public static String[] splitByDelimiters(String string, String delimiters) {
        char[][] comps = CharScanner.splitByChars(FastStringUtils.toCharArray(string), delimiters.toCharArray());
        return Str.fromCharArrayOfArrayToStringArray(comps);
    }

    public static String[] splitByCharsNoneEmpty(String string, char ... delimiters) {
        char[][] comps = CharScanner.splitByCharsNoneEmpty(FastStringUtils.toCharArray(string), delimiters);
        return Str.fromCharArrayOfArrayToStringArray(comps);
    }

    public static String removeChars(String string, char ... delimiters) {
        char[][] comps = CharScanner.splitByCharsNoneEmpty(FastStringUtils.toCharArray(string), delimiters);
        return new String(Chr.add(comps));
    }

    public static String[] splitByCharsNoneEmpty(String string, int start, int end, char ... delimiters) {
        Exceptions.requireNonNull(string);
        char[][] comps = CharScanner.splitByCharsNoneEmpty(FastStringUtils.toCharArray(string), start, end, delimiters);
        return Str.fromCharArrayOfArrayToStringArray(comps);
    }

    public static float parseFloat(String buffer, int from, int to) {
        return CharScanner.parseFloat(FastStringUtils.toCharArray(buffer), from, to);
    }

    public static float parseFloat(String buffer) {
        return CharScanner.parseFloat(FastStringUtils.toCharArray(buffer));
    }

    public static double parseDouble(String buffer, int from, int to) {
        return CharScanner.parseDouble(FastStringUtils.toCharArray(buffer), from, to);
    }

    public static double parseDouble(String buffer) {
        return CharScanner.parseDouble(FastStringUtils.toCharArray(buffer));
    }

    public static int parseInt(String buffer, int from, int to) {
        return CharScanner.parseInt(FastStringUtils.toCharArray(buffer), from, to);
    }

    public static int parseInt(String buffer) {
        return CharScanner.parseInt(FastStringUtils.toCharArray(buffer));
    }

    public static long parseLong(String buffer, int from, int to) {
        return CharScanner.parseLong(FastStringUtils.toCharArray(buffer), from, to);
    }

    public static long parseLong(String buffer) {
        return CharScanner.parseLong(FastStringUtils.toCharArray(buffer));
    }

    public static short parseShort(String buffer, int from, int to) {
        return (short)CharScanner.parseInt(FastStringUtils.toCharArray(buffer), from, to);
    }

    public static short parseShort(String buffer) {
        return (short)CharScanner.parseInt(FastStringUtils.toCharArray(buffer));
    }

    public static short parseByte(String buffer, int from, int to) {
        return (byte)CharScanner.parseInt(FastStringUtils.toCharArray(buffer), from, to);
    }

    public static short parseByte(String buffer) {
        return (byte)CharScanner.parseInt(FastStringUtils.toCharArray(buffer));
    }

    public static int findWhiteSpace(String buffer) {
        return CharScanner.findWhiteSpace(FastStringUtils.toCharArray(buffer));
    }

    public static String substringAfter(String string, String after) {
        int index = StringScanner.findString(string, after);
        if (index == -1) {
            return "";
        }
        return Str.slc(string, index + after.length());
    }

    private static int findString(String string, String after) {
        return CharScanner.findChars(FastStringUtils.toCharArray(after), FastStringUtils.toCharArray(string));
    }

    public static String substringBefore(String string, String before) {
        int index = StringScanner.findString(string, before);
        if (index == -1) {
            return "";
        }
        return Str.slcEnd(string, index);
    }
}

