/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.primitive;

import io.advantageous.boon.core.Exceptions;
import io.advantageous.boon.core.reflection.Invoker;
import java.nio.charset.StandardCharsets;

public class Byt {
    public static byte[] grow(byte[] array, int size) {
        byte[] newArray = new byte[array.length + size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static byte[] grow(byte[] array) {
        byte[] newArray = new byte[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static byte[] shrink(byte[] array, int size) {
        byte[] newArray = new byte[array.length - size];
        System.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static byte[] compact(byte[] array) {
        int nullCount = 0;
        for (byte ch : array) {
            if (ch != 0) continue;
            ++nullCount;
        }
        byte[] newArray = new byte[array.length - nullCount];
        int j = 0;
        for (byte ch : array) {
            if (ch == 0) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static byte[] arrayOfByte(int size) {
        return new byte[size];
    }

    public static byte[] array(byte ... array) {
        return array;
    }

    public static byte[] bytes(byte ... array) {
        return array;
    }

    public static byte[] bytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static int len(byte[] array) {
        return array.length;
    }

    public static int lengthOf(byte[] array) {
        return array.length;
    }

    public static byte atIndex(byte[] array, int index) {
        return Byt.idx(array, index);
    }

    public static byte idx(byte[] array, int index) {
        int i = Byt.calculateIndex(array, index);
        return array[i];
    }

    public static void atIndex(byte[] array, int index, byte value) {
        Byt.idx(array, index, value);
    }

    public static void idx(byte[] array, int index, byte value) {
        int i = Byt.calculateIndex(array, index);
        array[i] = value;
    }

    public static byte[] sliceOf(byte[] array, int startIndex, int endIndex) {
        return Byt.slc(array, startIndex, endIndex);
    }

    public static byte[] slc(byte[] array, int startIndex, int endIndex) {
        int start = Byt.calculateIndex(array, startIndex);
        int end = Byt.calculateEndIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        byte[] newArray = new byte[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    public static byte[] sliceOf(byte[] array, int startIndex) {
        return Byt.slc(array, startIndex);
    }

    public static byte[] slc(byte[] array, int startIndex) {
        int start = Byt.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        byte[] newArray = new byte[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    public static byte[] endSliceOf(byte[] array, int endIndex) {
        return Byt.slcEnd(array, endIndex);
    }

    public static byte[] slcEnd(byte[] array, int endIndex) {
        int end = Byt.calculateEndIndex(array, endIndex);
        int newLength = end;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        byte[] newArray = new byte[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    public static boolean in(int value, byte ... array) {
        for (byte currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    public static boolean inIntArray(byte value, int[] array) {
        for (int currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    public static boolean in(int value, int offset, byte[] array) {
        for (int index = offset; index < array.length; ++index) {
            byte currentValue = array[index];
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    public static boolean in(int value, int offset, int end, byte[] array) {
        for (int index = offset; index < end; ++index) {
            byte currentValue = array[index];
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    public static byte[] copy(byte[] array) {
        Exceptions.requireNonNull(array);
        byte[] newArray = new byte[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static byte[] copy(byte[] array, int offset, int length) {
        Exceptions.requireNonNull(array);
        byte[] newArray = new byte[length];
        System.arraycopy(array, offset, newArray, 0, length);
        return newArray;
    }

    public static byte[] add(byte[] array, byte v) {
        byte[] newArray = new byte[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = v;
        return newArray;
    }

    public static byte[] add(byte[] array, byte[] array2) {
        byte[] newArray = new byte[array.length + array2.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    public static byte[] insert(byte[] array, int idx, byte v) {
        if (idx >= array.length) {
            return Byt.add(array, v);
        }
        int index = Byt.calculateIndex(array, idx);
        byte[] newArray = new byte[array.length + 1];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingIndex = array.length - index;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        }
        newArray[index] = v;
        return newArray;
    }

    public static byte[] insert(byte[] array, int fromIndex, byte[] values) {
        if (fromIndex >= array.length) {
            return Byt.add(array, values);
        }
        int index = Byt.calculateIndex(array, fromIndex);
        byte[] newArray = new byte[array.length + values.length];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int toIndex = index + values.length;
        int remainingIndex = newArray.length - toIndex;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        }
        int i = index;
        int j = 0;
        while (i < toIndex) {
            newArray[i] = values[j];
            ++i;
            ++j;
        }
        return newArray;
    }

    private static int calculateIndex(byte[] array, int originalIndex) {
        int length = array.length;
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }

    private static int calculateEndIndex(byte[] array, int originalIndex) {
        int length = array.length;
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > length) {
            index = length;
        }
        return index;
    }

    public static int idxInt(byte[] bytes, int off) {
        return (bytes[off + 3] & 0xFF) + ((bytes[off + 2] & 0xFF) << 8) + ((bytes[off + 1] & 0xFF) << 16) + (bytes[off] << 24);
    }

    public static byte[] addInt(byte[] array, int v) {
        byte[] arrayToHoldInt = new byte[4];
        Byt.intTo(arrayToHoldInt, 0, v);
        return Byt.add(array, arrayToHoldInt);
    }

    public static byte[] insertIntInto(byte[] array, int index, int v) {
        byte[] arrayToHoldInt = new byte[4];
        Byt.intTo(arrayToHoldInt, 0, v);
        return Byt.insert(array, index, arrayToHoldInt);
    }

    public static void intTo(byte[] b, int off, int val) {
        b[off + 3] = (byte)val;
        b[off + 2] = (byte)(val >>> 8);
        b[off + 1] = (byte)(val >>> 16);
        b[off] = (byte)(val >>> 24);
    }

    public static void longTo(byte[] b, int off, long val) {
        b[off + 7] = (byte)val;
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off] = (byte)(val >>> 56);
    }

    public static byte[] addLong(byte[] array, long value) {
        byte[] holder = new byte[8];
        Byt.longTo(holder, 0, value);
        return Byt.add(array, holder);
    }

    public static long idxUnsignedInt(byte[] bytes, int off) {
        return ((long)bytes[off + 3] & 0xFFL) + (((long)bytes[off + 2] & 0xFFL) << 8) + (((long)bytes[off + 1] & 0xFFL) << 16) + (((long)bytes[off] & 0xFFL) << 24);
    }

    public static long idxLong(byte[] b, int off) {
        return ((long)b[off + 7] & 0xFFL) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + ((long)b[off] << 56);
    }

    public static short idxShort(byte[] b, int off) {
        return (short)((b[off + 1] & 0xFF) + (b[off] << 8));
    }

    public static byte[] addShort(byte[] array, short value) {
        byte[] holder = new byte[2];
        Byt.shortTo(holder, 0, value);
        return Byt.add(array, holder);
    }

    public static byte[] insertShortInto(byte[] array, int index, short value) {
        byte[] holder = new byte[2];
        Byt.shortTo(holder, 0, value);
        return Byt.insert(array, index, holder);
    }

    public static void shortTo(byte[] b, int off, short val) {
        b[off + 1] = (byte)val;
        b[off] = (byte)(val >>> 8);
    }

    public static char idxChar(byte[] b, int off) {
        return (char)((b[off + 1] & 0xFF) + (b[off] << 8));
    }

    public static byte[] addChar(byte[] array, char value) {
        byte[] holder = new byte[2];
        Byt.charTo(holder, 0, value);
        return Byt.add(array, holder);
    }

    public static byte[] insertCharInto(byte[] array, int index, char value) {
        byte[] holder = new byte[2];
        Byt.charTo(holder, 0, value);
        return Byt.insert(array, index, holder);
    }

    public static void charTo(byte[] b, int off, char val) {
        b[off + 1] = (byte)val;
        b[off] = (byte)(val >>> 8);
    }

    public static void charTo(byte[] b, char val) {
        b[1] = (byte)val;
        b[0] = (byte)(val >>> 8);
    }

    public static float idxFloat(byte[] array, int off) {
        return Float.intBitsToFloat(Byt.idxInt(array, off));
    }

    public static byte[] addFloat(byte[] array, float value) {
        byte[] holder = new byte[4];
        Byt.floatTo(holder, 0, value);
        return Byt.add(array, holder);
    }

    public static byte[] insertFloatInto(byte[] array, int index, float value) {
        byte[] holder = new byte[4];
        Byt.floatTo(holder, 0, value);
        return Byt.insert(array, index, holder);
    }

    public static void floatTo(byte[] array, int off, float val) {
        Byt.intTo(array, off, Float.floatToIntBits(val));
    }

    public static byte[] addDouble(byte[] array, double value) {
        Exceptions.requireNonNull(array);
        byte[] holder = new byte[4];
        Byt.doubleTo(holder, 0, value);
        return Byt.add(array, holder);
    }

    public static byte[] insertDoubleInto(byte[] array, int index, double value) {
        Exceptions.requireNonNull(array);
        byte[] holder = new byte[4];
        Byt.doubleTo(holder, 0, value);
        return Byt.insert(array, index, holder);
    }

    public static void doubleTo(byte[] b, int off, double val) {
        Byt.longTo(b, off, Double.doubleToLongBits(val));
    }

    public static double idxDouble(byte[] b, int off) {
        return Double.longBitsToDouble(Byt.idxLong(b, off));
    }

    public static void _idx(byte[] array, int startIndex, byte[] input) {
        try {
            System.arraycopy(input, 0, array, startIndex, input.length);
        }
        catch (Exception ex) {
            Exceptions.handle(String.format("array size %d, startIndex %d, input length %d", array.length, startIndex, input.length), (Throwable)ex);
        }
    }

    public static void _idx(byte[] array, int startIndex, byte[] input, int length) {
        try {
            System.arraycopy(input, 0, array, startIndex, length);
        }
        catch (Exception ex) {
            Exceptions.handle(String.format("array size %d, startIndex %d, input length %d", array.length, startIndex, input.length), (Throwable)ex);
        }
    }

    public static void _idx(byte[] output, int ouputStartIndex, byte[] input, int inputOffset, int length) {
        try {
            System.arraycopy(input, inputOffset, output, ouputStartIndex, length);
        }
        catch (Exception ex) {
            Exceptions.handle(String.format("array size %d, startIndex %d, input length %d", output.length, ouputStartIndex, input.length), (Throwable)ex);
        }
    }

    public static int idxUnsignedShort(byte[] buffer, int off) {
        int ch1 = buffer[off] & 0xFF;
        int ch2 = buffer[off + 1] & 0xFF;
        return (ch1 << 8) + ch2;
    }

    public static short idxUnsignedByte(byte[] array, int location) {
        return (short)(array[location] & 0xFF);
    }

    public static void unsignedIntTo(byte[] b, int off, long val) {
        b[off + 3] = (byte)val;
        b[off + 2] = (byte)(val >>> 8);
        b[off + 1] = (byte)(val >>> 16);
        b[off] = (byte)(val >>> 24);
    }

    public static void unsignedShortTo(byte[] buffer, int off, int value) {
        buffer[off + 1] = (byte)value;
        buffer[off] = (byte)(value >>> 8);
    }

    public static void unsignedByteTo(byte[] buffer, int off, short value) {
        buffer[off] = (byte)value;
    }

    public static String utfString(byte[] jsonBytes) {
        return new String(jsonBytes, StandardCharsets.UTF_8);
    }

    public static int reduceBy(byte[] array, Object object) {
        int sum = 0;
        for (byte v : array) {
            sum = (Integer)Invoker.invokeReducer(object, sum, v);
        }
        return sum;
    }

    public static boolean equalsOrDie(byte[] expected, byte[] got) {
        if (expected.length != got.length) {
            Exceptions.die("Lengths did not match, expected length", expected.length, "but got", got.length);
        }
        for (int index = 0; index < expected.length; ++index) {
            if (expected[index] == got[index]) continue;
            Exceptions.die("value at index did not match index", index, "expected value", expected[index], "but got", got[index]);
        }
        return true;
    }

    public static boolean equals(byte[] expected, byte[] got) {
        if (expected.length != got.length) {
            return false;
        }
        for (int index = 0; index < expected.length; ++index) {
            if (expected[index] == got[index]) continue;
            return false;
        }
        return true;
    }
}

