/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.primitive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class SimpleLRUCache<K, V> {
    Map<K, V> map = new LinkedHashMap();

    public SimpleLRUCache(int limit) {
        this.map = new InternalCacheLinkedList(limit, true);
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public V getSilent(K key) {
        V value = this.map.get(key);
        if (value != null) {
            this.map.remove(key);
            this.map.put(key, value);
        }
        return value;
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public Collection<V> values() {
        return new ArrayList<V>(this.map.values());
    }

    public Collection<K> keys() {
        return new ArrayList<K>(this.map.keySet());
    }

    private static class InternalCacheLinkedList<K, V>
    extends LinkedHashMap<K, V> {
        final int limit;

        InternalCacheLinkedList(int limit, boolean lru) {
            super(16, 0.75f, lru);
            this.limit = limit;
        }

        @Override
        protected final boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return super.size() > this.limit;
        }
    }
}

