/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder;

import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;
import ru.infor.frc.report.builder.data.ReportData;
import ru.infor.frc.report.builder.xls.XLSBuilder;
import ru.infor.frc.report.utils.FileUtil;

public abstract class ReportBuilder {
    private static final Logger logger = Logger.getLogger(ReportBuilder.class);
    public static final Integer ABA_NONE = 0;
    public static final Integer ABA_OPEN = 1;
    public static final Integer ABA_PRINT = 2;
    public static final Integer ABA_OPEN_AND_PRINT = 3;
    public static final Integer XLS_CLASS_CODE = 1;
    public static final String XLS_CLASS_STRING = "xls";

    protected abstract File buildReport(ReportData var1, File var2);

    public static ReportBuilder getBuilder(Integer classBuilder) {
        if (XLS_CLASS_CODE.equals(classBuilder)) {
            return XLSBuilder.getBuilderInstance();
        }
        return null;
    }

    public static ReportBuilder getBuilder(String classBuilder) {
        if (XLS_CLASS_STRING.equals(classBuilder)) {
            return XLSBuilder.getBuilderInstance();
        }
        return null;
    }

    protected void afterBuildActionFire(File templateFile, Integer afterBuildAction, Properties afterBuildActionProperties) {
        if (templateFile == null) {
            return;
        }
        if (afterBuildAction == null || ABA_NONE.equals(afterBuildAction)) {
            return;
        }
        if (afterBuildActionProperties == null) {
            afterBuildActionProperties = new Properties();
        }
        if ((afterBuildAction & ABA_OPEN) == ABA_OPEN && !FileUtil.openFile(templateFile, afterBuildActionProperties)) {
            logger.error((Object)"Can't open report.", new Throwable());
        }
        if ((afterBuildAction & ABA_PRINT) == ABA_PRINT && !FileUtil.printFile(templateFile, afterBuildActionProperties)) {
            logger.error((Object)"Can't print report.", new Throwable());
        }
    }

    public File buildReport(ReportData reportData, File templateFile, Integer afterBuildAction, Properties afterBuildActionProperties) {
        File res = this.buildReport(reportData, templateFile);
        this.afterBuildActionFire(res, afterBuildAction, afterBuildActionProperties);
        return res;
    }
}

