/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls;

import java.util.ArrayList;
import ru.infor.frc.report.builder.xls.FRCFunction;
import ru.infor.frc.report.builder.xls.schema.GroupTemplateSchema;
import ru.infor.frc.report.builder.xls.schema.QueryTemplateSchema;
import ru.infor.frc.report.builder.xls.schema.XLSTemplateSchema;

public class CommonUtils {
    public static ArrayList<Object> getRows(XLSTemplateSchema template, String tag) {
        String[] mas;
        ArrayList<Object> res = null;
        if (template != null && tag != null && (mas = tag.split("/.")) != null) {
            int qIndex;
            if (mas[0].equals("title")) {
                res = template.getTitleRows();
            }
            if (mas[0].equals("end")) {
                res = template.getEndRows();
            }
            if (mas[0].equals("query") && (qIndex = Integer.parseInt(mas[1])) < template.getQueries().size()) {
                int gIndex;
                QueryTemplateSchema query = template.getQueries().get(qIndex);
                if (mas[2].equals("title")) {
                    res = query.getTitleRows();
                }
                if (mas[2].equals("end")) {
                    res = query.getEndRows();
                }
                if (mas[2].equals("detail")) {
                    res = query.getDetailRows();
                }
                if (mas[2].equals("gr") && (gIndex = Integer.parseInt(mas[3])) < query.getGroups().size()) {
                    GroupTemplateSchema group = query.getGroups().get(gIndex);
                    if (mas[4].equals("head")) {
                        res = group.getTitleRows();
                    }
                    if (mas[4].equals("end")) {
                        res = group.getEndRows();
                    }
                }
            }
        }
        return res;
    }

    public static XLSTemplateSchema getPattern(XLSTemplateSchema res, ArrayList<String> rowPatterns, Object row, ArrayList<FRCFunction> func) {
        if (res == null) {
            res = new XLSTemplateSchema();
        }
        if (rowPatterns != null && rowPatterns.size() > 0 && row != null) {
            String q = rowPatterns.get(0);
            if ("title".equalsIgnoreCase(q)) {
                res.getTitleRows().add(row);
            }
            if ("end".equalsIgnoreCase(q)) {
                res.getEndRows().add(row);
            }
            if ("query".equalsIgnoreCase(q)) {
                Integer index = new Double(rowPatterns.get(1)).intValue() - 1;
                while (index >= res.getQueries().size()) {
                    res.getQueries().add(new QueryTemplateSchema());
                }
                QueryTemplateSchema query = res.getQueries().get(index);
                rowPatterns.remove(0);
                rowPatterns.remove(0);
                CommonUtils.updateQueryPattern(query, rowPatterns, row, func);
            }
        }
        return res;
    }

    private static QueryTemplateSchema updateQueryPattern(QueryTemplateSchema query, ArrayList<String> rowPatterns, Object row, ArrayList<FRCFunction> func) {
        if (query != null && rowPatterns != null && row != null) {
            String w = rowPatterns.get(0);
            if ("title".equalsIgnoreCase(w)) {
                query.getTitleRows().add(row);
            }
            if ("end".equalsIgnoreCase(w)) {
                query.getEndRows().add(row);
            }
            if ("detail".equalsIgnoreCase(w)) {
                query.getDetailRows().add(row);
            }
            if ("gr".equalsIgnoreCase(w)) {
                Integer index = new Double(rowPatterns.get(1)).intValue() - 1;
                while (index >= query.getGroups().size()) {
                    query.getGroups().add(new GroupTemplateSchema());
                }
                GroupTemplateSchema group = query.getGroups().get(index);
                rowPatterns.remove(0);
                rowPatterns.remove(0);
                CommonUtils.updateQueryGroup(group, rowPatterns, row, func);
            }
        }
        return query;
    }

    private static GroupTemplateSchema updateQueryGroup(GroupTemplateSchema group, ArrayList<String> rowPatterns, Object row, ArrayList<FRCFunction> func) {
        if (group != null && rowPatterns != null && row != null) {
            String e = rowPatterns.get(0);
            if ("head".equalsIgnoreCase(e)) {
                group.getTitleRows().add(row);
            }
            if ("end".equalsIgnoreCase(e)) {
                group.getEndRows().add(row);
            }
            if ("column".equalsIgnoreCase(e)) {
                String columnString = rowPatterns.get(1);
                group.setColumns(columnString);
            }
            if (func != null) {
                group.getFunctions().addAll(func);
            }
        }
        return group;
    }
}

