/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.infor.frc.report.builder.data.QueryResult;
import ru.infor.frc.report.builder.data.QueryResultRow;
import ru.infor.frc.report.builder.data.ReportData;
import ru.infor.frc.report.builder.data.ReportParameter;
import ru.infor.frc.report.builder.xls.FRCFunction;
import ru.infor.frc.report.builder.xls.PrintingRows;
import ru.infor.frc.report.builder.xls.schema.GroupTemplateSchema;
import ru.infor.frc.report.builder.xls.schema.QueryTemplateSchema;
import ru.infor.frc.report.builder.xls.schema.XLSTemplateSchema;

public class Convertor {
    private static NumberFormat numberFormat = new DecimalFormat("##0,00");

    public static List<PrintingRows> convertToTagList(ReportData reportData, XLSTemplateSchema parsedTemplate) {
        ArrayList<PrintingRows> res = new ArrayList<PrintingRows>();
        if (reportData != null && parsedTemplate != null) {
            HashMap<String, String> map = Convertor.getParametersMap(reportData.getParameters());
            res.add(new PrintingRows("title", map));
            ArrayList<QueryTemplateSchema> queries = parsedTemplate.getQueries();
            ArrayList<QueryResult> queriesData = reportData.getQueries();
            for (int i = 0; i < queries.size(); ++i) {
                QueryTemplateSchema queryTemplateSchema = queries.get(i);
                QueryResult queryResult = queriesData.get(i);
                res.addAll(Convertor.convertQueryToList(queryResult, queryTemplateSchema, "query".concat("/.").concat(String.valueOf(i))));
            }
            res.add(new PrintingRows("end", map));
        }
        return res;
    }

    private static List<PrintingRows> convertQueryToList(QueryResult queryResult, QueryTemplateSchema queryTemplateSchema, String queryString) {
        ArrayList<PrintingRows> res = null;
        if (queryResult != null && queryTemplateSchema != null) {
            res = new ArrayList<PrintingRows>();
            res.add(new PrintingRows(queryString.concat("/.").concat("title"), null));
            ArrayList<String> columnName = queryResult.getColumnName();
            ArrayList<QueryResultRow> listD = queryResult.getRows();
            res.addAll(Convertor.grouping(columnName, listD, queryTemplateSchema, 0, queryString));
            res.add(new PrintingRows(queryString.concat("/.").concat("end"), null));
        }
        return res;
    }

    private static List<PrintingRows> grouping(ArrayList<String> columnName, ArrayList<QueryResultRow> listD, QueryTemplateSchema queryTemplateSchema, int index, String queryString) {
        ArrayList<PrintingRows> res = null;
        if (columnName != null && listD != null && queryTemplateSchema != null) {
            res = new ArrayList<PrintingRows>(listD.size());
            if (listD.size() > 0) {
                if (index >= queryTemplateSchema.getGroups().size()) {
                    for (int i = 0; i < listD.size(); ++i) {
                        HashMap<String, String> map = Convertor.getValuesMap(columnName, listD.get(i).getColumnValues());
                        res.add(new PrintingRows(queryString.concat("/.").concat("detail"), map));
                    }
                } else {
                    GroupTemplateSchema gr = queryTemplateSchema.getGroups().get(index);
                    String groupString = queryString.concat("/.").concat("gr").concat("/.").concat(String.valueOf(index));
                    String startGroupString = groupString.concat("/.").concat("head");
                    String endGroupString = groupString.concat("/.").concat("end");
                    HashMap<String, String> map = new HashMap<String, String>();
                    res.add(new PrintingRows(startGroupString, map));
                    Object obj = Convertor.getColumn(gr.getColumns(), columnName, listD.get(0));
                    int start = 0;
                    for (int i = 0; i < listD.size(); ++i) {
                        Object newObj = Convertor.getColumn(gr.getColumns(), columnName, listD.get(i));
                        if (!Convertor.ObjectsNotEqual(obj, newObj)) continue;
                        ArrayList<QueryResultRow> subListD = new ArrayList<QueryResultRow>(listD.subList(start, i));
                        map.putAll(Convertor.getFunctionsResult(gr.getFunctions(), columnName, subListD));
                        res.addAll(Convertor.grouping(columnName, subListD, queryTemplateSchema, index + 1, queryString));
                        res.add(new PrintingRows(endGroupString, map));
                        map = new HashMap();
                        res.add(new PrintingRows(startGroupString, map));
                        obj = newObj;
                        start = i;
                    }
                    map.putAll(Convertor.getFunctionsResult(gr.getFunctions(), columnName, listD.subList(start, listD.size())));
                    res.addAll(Convertor.grouping(columnName, new ArrayList<QueryResultRow>(listD.subList(start, listD.size())), queryTemplateSchema, index + 1, queryString));
                    res.add(new PrintingRows(endGroupString, map));
                }
            }
        }
        return res;
    }

    private static HashMap<String, String> getFunctionsResult(ArrayList<FRCFunction> functions, ArrayList<String> columnName, List<QueryResultRow> subList) {
        HashMap<String, String> res = null;
        if (functions != null && columnName != null && subList != null) {
            res = new HashMap<String, String>();
            for (int i = 0; i < functions.size(); ++i) {
                int index;
                FRCFunction fun = functions.get(i);
                String operand = fun.getOperand();
                if (operand != null) {
                    index = columnName.indexOf(operand = operand.substring(1));
                    if (index <= 0) continue;
                    ArrayList<BigDecimal> columnVals = new ArrayList<BigDecimal>(subList.size());
                    for (int j = 0; j < subList.size(); ++j) {
                        BigDecimal bd = null;
                        try {
                            String val = subList.get(j).getColumnValues().get(index);
                            bd = new BigDecimal(numberFormat.parse(val).doubleValue());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (bd == null) continue;
                        columnVals.add(bd);
                    }
                    BigDecimal calculated = fun.calculate(columnVals);
                    res.put(fun.getFunctionString(), String.valueOf(calculated));
                    continue;
                }
                operand = fun.getSignature().substring(1);
                index = columnName.indexOf(operand);
                if (index <= 0 || subList.size() <= 0) continue;
                res.put(fun.getFunctionString(), subList.get(0).getColumnValues().get(index));
            }
        }
        return res;
    }

    private static boolean ObjectsNotEqual(Object obj, Object newObj) {
        if (obj == null && newObj == null) {
            return false;
        }
        boolean res = false;
        res = obj != null ? !obj.equals(newObj) : !newObj.equals(obj);
        return res;
    }

    private static HashMap<String, String> getValuesMap(ArrayList<String> columnName, ArrayList<String> arrayList) {
        HashMap<String, String> res = null;
        if (columnName != null && arrayList != null) {
            res = new HashMap<String, String>(columnName.size());
            for (int i = 0; i < columnName.size(); ++i) {
                String obj = "";
                if (i < arrayList.size()) {
                    obj = arrayList.get(i);
                }
                res.put("%".concat(columnName.get(i)), obj);
            }
        }
        return res;
    }

    private static HashMap<String, String> getParametersMap(ArrayList<ReportParameter> arrayList) {
        HashMap<String, String> res = null;
        if (arrayList != null) {
            res = new HashMap<String, String>(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                ReportParameter parameter = arrayList.get(i);
                res.put("$".concat(parameter.getName()), String.valueOf(parameter.getValue()));
            }
        }
        return res;
    }

    private static Object getColumn(String columns, ArrayList<String> columnName, QueryResultRow queryResultRow) {
        int i;
        String res = null;
        if (columns != null && columnName != null && queryResultRow != null && (i = columnName.indexOf(columns.substring(1))) > 0) {
            res = queryResultRow.getColumnValues().get(i);
        }
        return res;
    }
}

