/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls;

import java.math.BigDecimal;
import java.util.ArrayList;

public class FRCFunction {
    private String functionString;
    private String signature;
    private String operand;
    private Double value;

    public Double getValue() {
        return this.value;
    }

    public void resetValue() {
        this.value = new Double(0.0);
    }

    protected FRCFunction() {
    }

    public FRCFunction(String fun) {
        this.functionString = fun;
        this.signature = FRCFunction.getSignature(fun);
        this.operand = FRCFunction.getOperand(fun);
    }

    public String getSignature() {
        return this.signature;
    }

    public String getOperand() {
        return this.operand;
    }

    public BigDecimal calculate(ArrayList<BigDecimal> columnVals) {
        BigDecimal res = null;
        if (columnVals != null) {
            res = new BigDecimal(0.0);
            res.setScale(4, 4);
            for (int i = 0; i < columnVals.size(); ++i) {
                BigDecimal next = columnVals.get(i);
                if (next == null) continue;
                res = res.add(next);
            }
        }
        return res;
    }

    public static String getSignature(String funString) {
        String res = null;
        if (funString != null && !funString.isEmpty() && funString.startsWith("%")) {
            int i = funString.indexOf("(");
            res = i > 0 ? funString.substring(0, i) : funString.substring(0);
        }
        return res;
    }

    public static String getOperand(String funString) {
        int i;
        String res = null;
        if (funString != null && !funString.isEmpty() && funString.startsWith("%") && (i = funString.indexOf("(")) > 0) {
            ++i;
            int j = funString.indexOf(")");
            if (j > 0) {
                res = funString.substring(i, j);
            }
        }
        return res;
    }

    public String getFunctionString() {
        return this.functionString;
    }
}

