/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls;

import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import ru.infor.frc.report.builder.ReportBuilder;
import ru.infor.frc.report.builder.data.QueryResult;
import ru.infor.frc.report.builder.data.ReportData;
import ru.infor.frc.report.builder.data.ReportParameter;
import ru.infor.frc.report.builder.xls.XLSDataWriter;
import ru.infor.frc.report.builder.xls.XLSParser;
import ru.infor.frc.report.builder.xls.schema.XLSTemplateSchema;
import ru.infor.frc.report.builder.xls.vba.VBA_XLS_Builder;
import ru.infor.frc.report.utils.OSUtils;

public abstract class XLSBuilder
extends ReportBuilder {
    private static Logger logger = Logger.getLogger(XLSBuilder.class);
    private static final String TempPathSysPropName = "java.io.tmpdir";
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir") + File.separator + "FRC_REPORT" + File.separator;
    public static final File TEMP_DIR_FILE = new File(TEMP_DIR);

    protected abstract XLSDataWriter getWriter();

    protected abstract XLSParser getParser();

    public static XLSBuilder getBuilderInstance() {
        VBA_XLS_Builder res = null;
        if (OSUtils.isWindowsOS()) {
            res = new VBA_XLS_Builder();
        }
        return res;
    }

    @Override
    public File buildReport(ReportData reportData, File templateFile) {
        File res = templateFile;
        if (reportData == null) {
            logger.error((Object)"Report data can't be null.", new Throwable());
            return res;
        }
        reportData.getParameters().add(ReportParameter.getInstance("VERSIONFRC", "2"));
        ArrayList<QueryResult> queries = reportData.getQueries();
        for (int i = 0; i < queries.size(); ++i) {
            reportData.getParameters().add(ReportParameter.getInstance("QUERY".concat(String.valueOf(i + 1)).concat("COUNT"), String.valueOf(queries.get(i).getRows().size())));
        }
        if (templateFile == null) {
            logger.error((Object)"Template file can't be null.", new Throwable());
            return res;
        }
        XLSBuilder builder = XLSBuilder.getBuilderInstance();
        if (builder != null) {
            XLSDataWriter writer = builder.getWriter();
            if (writer == null) {
                logger.error((Object)"Have no data writer for current OS.", new Throwable());
                return res;
            }
            XLSParser parser = builder.getParser();
            if (parser == null) {
                logger.error((Object)"Have no xls template parser for current OS.", new Throwable());
                return res;
            }
            XLSTemplateSchema parsedTemplate = parser.parseFile(templateFile);
            writer.writeParameter(parsedTemplate, templateFile, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", reportData.getParameters());
            writer.writeDataOnSheet(parsedTemplate, templateFile, "\u0420\u0430\u0431\u043e\u0447\u0438\u0439", reportData);
        } else {
            logger.error((Object)"Can't find XLS builder for current OS name.", new Throwable());
        }
        return res;
    }

    static {
        if (!TEMP_DIR_FILE.exists() || !TEMP_DIR_FILE.isDirectory()) {
            TEMP_DIR_FILE.mkdirs();
        }
    }
}

