/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls.poi.datawriter;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ru.infor.frc.report.builder.xls.poi.parser.CommonXLSOperation;

public class BuilderContext {
    private static Logger logger = Logger.getLogger(BuilderContext.class);
    private HSSFWorkbook srcWorkbook;
    private HSSFWorkbook dstWorkbook;
    private HSSFSheet srcSheet;
    private HSSFSheet dstSheet;
    private HSSFRow srcRow;
    private HSSFRow dstRow;

    public BuilderContext() {
    }

    public BuilderContext(File srcBookFile, String srcSheetName, File dstBookFile, String dstSheetName) {
        try {
            this.srcWorkbook = CommonXLSOperation.getWorkbook(srcBookFile);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.srcWorkbook != null) {
            this.srcSheet = CommonXLSOperation.getOrCreateSheet(this.srcWorkbook, srcSheetName);
        }
        try {
            this.dstWorkbook = CommonXLSOperation.getWorkbook(dstBookFile);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.dstWorkbook != null) {
            this.dstSheet = CommonXLSOperation.getOrCreateSheet(this.dstWorkbook, dstSheetName);
        }
    }

    public HSSFRow getSrcRow() {
        return this.srcRow;
    }

    public void setSrcRow(HSSFRow srcRow) {
        this.srcRow = srcRow;
    }

    public HSSFRow getDstRow() {
        return this.dstRow;
    }

    public void setDstRow(HSSFRow dstRow) {
        this.dstRow = dstRow;
    }

    public HSSFWorkbook getSrcWorkbook() {
        return this.srcWorkbook;
    }

    public void setSrcWorkbook(HSSFWorkbook srcWorkbook) {
        this.srcWorkbook = srcWorkbook;
    }

    public HSSFWorkbook getDstWorkbook() {
        return this.dstWorkbook;
    }

    public void setDstWorkbook(HSSFWorkbook dstWorkbook) {
        this.dstWorkbook = dstWorkbook;
    }

    public HSSFSheet getSrcSheet() {
        return this.srcSheet;
    }

    public void setSrcSheet(HSSFSheet srcSheet) {
        this.srcSheet = srcSheet;
    }

    public HSSFSheet getDstSheet() {
        return this.dstSheet;
    }

    public void setDstSheet(HSSFSheet dstSheet) {
        this.dstSheet = dstSheet;
    }
}

