/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls.poi.datawriter;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.RefPtg;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import ru.infor.frc.report.builder.xls.poi.datawriter.BuilderContext;
import ru.infor.frc.report.builder.xls.poi.parser.CommonXLSOperation;

public class CommonPOIReportOperation {
    private static Logger logger = Logger.getLogger(CommonPOIReportOperation.class);

    public static void appendRows(HSSFSheet dstSheet, ArrayList<Object> rows, HashMap<String, String> values, BuilderContext context) {
        if (dstSheet != null && rows != null && context != null) {
            for (int i = 0; i < rows.size(); ++i) {
                HSSFRow srcRow = (HSSFRow)rows.get(i);
                int rowIndex = dstSheet.getLastRowNum();
                rowIndex = rowIndex < 0 ? 0 : ++rowIndex;
                HSSFRow dstRow = CommonXLSOperation.getOrCreateRow(dstSheet, rowIndex);
                context.setSrcRow(srcRow);
                context.setDstRow(dstRow);
                CommonPOIReportOperation.copyRow(srcRow, dstRow, values, context);
            }
        }
    }

    private static void copyRow(HSSFRow srcRow, HSSFRow dstRow, HashMap<String, String> values, BuilderContext context) {
        if (srcRow != null && dstRow != null && context != null && context.getDstSheet() != null && context.getSrcSheet() != null) {
            HSSFSheet dstSheet = context.getDstSheet();
            dstRow.setHeight(srcRow.getHeight() > 0 ? srcRow.getHeight() : dstSheet.getDefaultRowHeight());
            short lastColumn = CommonPOIReportOperation.getLastColumn(srcRow);
            if (lastColumn < 0) {
                lastColumn = srcRow.getLastCellNum();
            }
            for (short i = srcRow.getFirstCellNum(); i < lastColumn; i = (short)(i + 1)) {
                HSSFCell srcCell = CommonXLSOperation.getCell(srcRow, i);
                if (srcCell == null) continue;
                HSSFCell dstCell = CommonXLSOperation.getOrCreateCell(dstRow, i);
                CommonPOIReportOperation.copyCell(srcCell, dstCell, values, context);
            }
            HSSFSheet srcSheet = context.getSrcSheet();
            for (int i = 0; i < srcSheet.getNumMergedRegions(); ++i) {
                CellRangeAddress region = srcSheet.getMergedRegion(i);
                if (region.getFirstRow() != srcRow.getRowNum()) continue;
                region.setLastRow(region.getLastRow() - region.getFirstRow() + dstRow.getRowNum());
                region.setFirstRow(dstRow.getRowNum());
                dstSheet.addMergedRegion(region);
            }
        }
    }

    private static void copyCell(HSSFCell srcCell, HSSFCell dstCell, HashMap<String, String> values, BuilderContext context) {
        if (srcCell != null && dstCell != null) {
            dstCell.setCellStyle(CommonPOIReportOperation.copyCellStyle(srcCell.getCellStyle(), context));
            CommonPOIReportOperation.copyCellValue(srcCell, dstCell, values, context);
        }
    }

    public static void copyCellValue(HSSFCell srcCell, HSSFCell dstCell, HashMap<String, String> values, BuilderContext context) {
        if (srcCell != null && dstCell != null && context != null && context.getSrcWorkbook() != null && context.getSrcRow() != null && context.getDstRow() != null) {
            String value = CommonXLSOperation.getCellValueString(srcCell);
            if (values != null && values.size() > 0) {
                value = CommonPOIReportOperation.setFormulaValues(value, values);
            }
            try {
                if (srcCell.getCellType() == 2) {
                    HSSFEvaluationWorkbook evaluationWorkbook = HSSFEvaluationWorkbook.create((HSSFWorkbook)context.getSrcWorkbook());
                    Ptg[] ptgs = FormulaParser.parse((String)value, (FormulaParsingWorkbook)evaluationWorkbook);
                    for (int k = 0; k < ptgs.length; ++k) {
                        ptgs[k] = CommonPOIReportOperation.shiftPtg(ptgs[k], dstCell.getColumnIndex() - srcCell.getColumnIndex(), context.getDstRow().getRowNum() - context.getSrcRow().getRowNum());
                    }
                    value = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)evaluationWorkbook, (Ptg[])ptgs);
                    dstCell.setCellFormula(value);
                } else {
                    dstCell.setCellType(1);
                    dstCell.setCellValue((RichTextString)new HSSFRichTextString(value));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                dstCell.setCellType(1);
                dstCell.setCellValue((RichTextString)new HSSFRichTextString(value));
            }
        }
    }

    private static String setFormulaValues(String value, HashMap<String, String> values) {
        String res = value;
        if (res != null && values != null && !res.isEmpty() && values.size() > 0) {
            for (String key : values.keySet()) {
                int index = res.indexOf(key);
                if (index < 0) continue;
                res = CommonPOIReportOperation.replaceAll(res, key, values.get(key));
            }
        }
        return res;
    }

    private static String replaceAll(String str, String key, String value) {
        String res = str;
        if (res != null && !res.isEmpty() && key != null && !key.isEmpty() && value != null) {
            int i = -1;
            while ((i = res.indexOf(key)) >= 0) {
                StringBuilder sb = new StringBuilder(3);
                sb.append(res.substring(0, i));
                sb.append(value);
                sb.append(res.substring(i + key.length()));
                res = sb.toString();
            }
        }
        return res;
    }

    private static Ptg shiftPtg(Ptg ptg, int dColumn, int dRow) {
        Ptg res = ptg;
        if (res != null) {
            if (res instanceof AreaPtg) {
                AreaPtg areaPtg = (AreaPtg)res;
                if (!areaPtg.isFirstColRelative()) {
                    areaPtg.setFirstColumn(areaPtg.getFirstColumn() + dColumn);
                }
                if (!areaPtg.isLastColRelative()) {
                    areaPtg.setLastColumn(areaPtg.getLastColumn() + dColumn);
                }
                if (!areaPtg.isFirstRowRelative()) {
                    areaPtg.setFirstRow(areaPtg.getFirstRow() + dRow);
                }
                if (!areaPtg.isLastRowRelative()) {
                    areaPtg.setLastRow(areaPtg.getLastRow() + dRow);
                }
            }
            if (res instanceof RefPtg) {
                RefPtg refPtg = (RefPtg)res;
                if (refPtg.isColRelative()) {
                    refPtg.setColumn(refPtg.getColumn() + dColumn);
                }
                if (refPtg.isRowRelative()) {
                    refPtg.setRow(refPtg.getRow() + dRow);
                }
            }
        }
        return res;
    }

    private static HSSFCellStyle copyCellStyle(HSSFCellStyle srcStyle, BuilderContext context) {
        HSSFCellStyle res = null;
        if (srcStyle != null && context != null && context.getDstWorkbook() != null) {
            res = context.getDstWorkbook().createCellStyle();
            res.setAlignment(srcStyle.getAlignment());
            res.setVerticalAlignment(srcStyle.getVerticalAlignment());
            res.setBorderBottom(srcStyle.getBorderBottom());
            res.setBorderLeft(srcStyle.getBorderLeft());
            res.setBorderRight(srcStyle.getBorderRight());
            res.setBorderTop(srcStyle.getBorderTop());
            res.setBottomBorderColor(srcStyle.getBottomBorderColor());
            res.setFillBackgroundColor(srcStyle.getFillBackgroundColor());
            res.setFillForegroundColor(srcStyle.getFillForegroundColor());
            res.setFillPattern(srcStyle.getFillPattern());
            res.setFont(srcStyle.getFont((Workbook)context.getDstWorkbook()));
            res.setHidden(srcStyle.getHidden());
            res.setIndention(srcStyle.getIndention());
            res.setLeftBorderColor(srcStyle.getLeftBorderColor());
            res.setLocked(srcStyle.getLocked());
            res.setRightBorderColor(srcStyle.getRightBorderColor());
            res.setRotation(srcStyle.getRotation());
            res.setTopBorderColor(srcStyle.getTopBorderColor());
            res.setWrapText(srcStyle.getWrapText());
            res.setDataFormat(srcStyle.getDataFormat());
        }
        return res;
    }

    public static void syncColumnWidth(HSSFSheet srcSheet, HSSFSheet dstSheet) {
        if (srcSheet != null && dstSheet != null) {
            dstSheet.setDefaultColumnWidth(srcSheet.getDefaultColumnWidth());
            int last = CommonPOIReportOperation.getLastColumn(srcSheet);
            for (int i = 0; i < last; ++i) {
                if (srcSheet.isColumnHidden(i)) {
                    dstSheet.setColumnHidden(i, true);
                    continue;
                }
                int width = srcSheet.getColumnWidth(i);
                if (width <= 0) {
                    width = dstSheet.getDefaultColumnWidth();
                }
                dstSheet.setColumnWidth(i, width);
            }
        }
    }

    private static short getLastColumn(HSSFSheet srcSheet) {
        short res = -1;
        if (srcSheet != null) {
            for (int i = srcSheet.getFirstRowNum(); i < srcSheet.getLastRowNum() && res < 0; ++i) {
                HSSFRow row = CommonXLSOperation.getRow(srcSheet, i);
                res = CommonPOIReportOperation.getLastColumn(row);
            }
        }
        return res;
    }

    private static short getLastColumn(HSSFRow row) {
        short res = -1;
        if (row != null) {
            for (short j = row.getFirstCellNum(); j < row.getLastCellNum() && res < 0; j = (short)(j + 1)) {
                String value;
                HSSFCell cell = CommonXLSOperation.getCell(row, j);
                if (cell == null || !(value = CommonXLSOperation.getCellValueString(cell)).startsWith("#")) continue;
                res = j;
            }
        }
        return res;
    }
}

