/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls.poi.datawriter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ru.infor.frc.report.builder.data.QueryResult;
import ru.infor.frc.report.builder.data.QueryResultRow;
import ru.infor.frc.report.builder.data.ReportData;
import ru.infor.frc.report.builder.data.ReportParameter;
import ru.infor.frc.report.builder.xls.CommonUtils;
import ru.infor.frc.report.builder.xls.PrintingRows;
import ru.infor.frc.report.builder.xls.XLSDataWriter;
import ru.infor.frc.report.builder.xls.poi.datawriter.BuilderContext;
import ru.infor.frc.report.builder.xls.poi.datawriter.CommonPOIReportOperation;
import ru.infor.frc.report.builder.xls.poi.parser.CommonXLSOperation;
import ru.infor.frc.report.builder.xls.schema.XLSTemplateSchema;

public class POIDataWriter
implements XLSDataWriter {
    private static Logger logger = Logger.getLogger(POIDataWriter.class);

    private static HSSFSheet printDataOnSheet(HSSFSheet sheet, ReportData reportData) {
        HSSFSheet res = sheet;
        if (sheet != null && reportData != null) {
            int rowIndex = 0;
            ArrayList<QueryResult> queries = reportData.getQueries();
            for (int i = 0; i < queries.size(); ++i) {
                QueryResult queryResult = queries.get(i);
                ArrayList<String> column = queryResult.getColumnName();
                rowIndex = POIDataWriter.printStringsToRow(sheet, rowIndex, column);
                ArrayList<QueryResultRow> rows = queryResult.getRows();
                for (int j = 0; j < rows.size(); ++j) {
                    ArrayList<String> values = rows.get(j).getColumnValues();
                    column = new ArrayList(values.size());
                    for (int k = 0; k < values.size(); ++k) {
                        column.add(values.get(k));
                    }
                    rowIndex = POIDataWriter.printStringsToRow(sheet, rowIndex, column);
                }
            }
        }
        return res;
    }

    private static int printStringsToRow(HSSFSheet sheet, int rowIndex, ArrayList<String> columnName) {
        HSSFRow row;
        int res = rowIndex;
        if (sheet != null & rowIndex >= 0 && columnName != null && (row = CommonXLSOperation.getOrCreateRow(sheet, rowIndex)) != null) {
            for (short i = 0; i < columnName.size(); i = (short)(i + 1)) {
                HSSFCell cell = CommonXLSOperation.getOrCreateCell(row, i);
                CommonXLSOperation.setCellValueString(cell, columnName.get(i));
            }
            ++res;
        }
        return res;
    }

    @Override
    public File writeDataOnSheet(XLSTemplateSchema parsedTemplate, File workBook, String sheetName, ReportData reportData) {
        File res = workBook;
        if (workBook != null && sheetName != null && reportData != null) {
            HSSFWorkbook wb = null;
            try {
                wb = CommonXLSOperation.getWorkbook(workBook);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (wb != null) {
                HSSFSheet sheet = CommonXLSOperation.getOrCreateSheet(wb, sheetName);
                POIDataWriter.printDataOnSheet(sheet, reportData);
                CommonXLSOperation.saveWorkbook(wb, workBook);
            }
        }
        return res;
    }

    private void syncColumnWidth(File srcBookFile, String srcSheetName, File dstBookFile, String dstSheetName) {
        HSSFWorkbook workbook = null;
        HSSFWorkbook destWB = null;
        try {
            workbook = CommonXLSOperation.getWorkbook(srcBookFile);
            destWB = CommonXLSOperation.getWorkbook(dstBookFile);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (workbook != null && destWB != null) {
            HSSFSheet srcSheet = CommonXLSOperation.getOrCreateSheet(workbook, srcSheetName);
            HSSFSheet dstSheet = CommonXLSOperation.getOrCreateSheet(destWB, dstSheetName);
            CommonPOIReportOperation.syncColumnWidth(srcSheet, dstSheet);
            CommonXLSOperation.saveWorkbook(destWB, dstBookFile);
        }
    }

    @Override
    public void writeDataOnSheet(XLSTemplateSchema parsedTemplate, File workBook, String sheetName, List<PrintingRows> list) {
        if (workBook != null && sheetName != null && parsedTemplate != null && list != null) {
            HSSFWorkbook wb = null;
            try {
                wb = CommonXLSOperation.getWorkbook(workBook);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (wb != null) {
                HSSFSheet sheet = CommonXLSOperation.getOrCreateSheet(wb, sheetName);
                BuilderContext context = new BuilderContext(parsedTemplate.getSrcBookFile(), parsedTemplate.getSrcSheetName(), workBook, sheetName);
                for (int i = 0; i < list.size(); ++i) {
                    PrintingRows printingRows = list.get(i);
                    ArrayList<Object> rows = CommonUtils.getRows(parsedTemplate, printingRows.getTag());
                    CommonPOIReportOperation.appendRows(sheet, rows, printingRows.getValuesMap(), context);
                }
                CommonXLSOperation.saveWorkbook(wb, workBook);
            }
        }
    }

    @Override
    public void syncColumnWidth(XLSTemplateSchema parsedTemplate, File dstBookFile, String dstSheetName) {
        this.syncColumnWidth(parsedTemplate.getSrcBookFile(), parsedTemplate.getSrcSheetName(), dstBookFile, dstSheetName);
    }

    @Override
    public void writeParameter(XLSTemplateSchema parsedTemplate, File workBook, String sheetName, List<ReportParameter> parameters) {
    }
}

