/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls.poi.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;

public class CommonXLSOperation {
    private static HashMap<String, HSSFWorkbook> map = new HashMap();
    private static Logger logger = Logger.getLogger(CommonXLSOperation.class);

    public static HSSFRow getRow(HSSFSheet sheet, int index) {
        HSSFRow res = null;
        if (sheet != null && index >= 0) {
            res = sheet.getRow(index);
        }
        return res;
    }

    public static HSSFCell getCell(HSSFSheet sheet, int rowIndex, int columnIndex) {
        HSSFCell res = null;
        HSSFRow row = CommonXLSOperation.getRow(sheet, rowIndex);
        res = CommonXLSOperation.getCell(row, columnIndex);
        return res;
    }

    public static HSSFCell getCell(HSSFRow row, int index) {
        HSSFCell res = null;
        if (row != null && index >= 0) {
            res = row.getCell(index);
        }
        return res;
    }

    public static String getCellValueString(HSSFCell cell) {
        String res = "";
        Object obj = CommonXLSOperation.getCellValue(cell);
        res = String.valueOf(obj);
        return res;
    }

    public static Object getCellValue(HSSFCell cell) {
        Object res = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case 4: {
                    res = cell.getBooleanCellValue();
                    break;
                }
                case 5: {
                    res = "Error:".concat(String.valueOf(cell.getErrorCellValue()));
                    break;
                }
                case 2: {
                    res = cell.getCellFormula();
                    break;
                }
                case 0: {
                    res = cell.getNumericCellValue();
                    break;
                }
                case 1: {
                    res = cell.getRichStringCellValue().getString();
                    break;
                }
                default: {
                    res = "";
                }
            }
        }
        return res;
    }

    public static HSSFSheet getOrCreateSheet(HSSFWorkbook workbook, String sheetName) {
        HSSFSheet res = null;
        if (workbook != null && sheetName != null && (res = workbook.getSheet(sheetName)) == null) {
            res = workbook.createSheet(sheetName);
        }
        return res;
    }

    public static HSSFRow getOrCreateRow(HSSFSheet sheet, int rowIndex) {
        HSSFRow res = null;
        if (sheet != null && rowIndex >= 0 && (res = sheet.getRow(rowIndex)) == null) {
            res = sheet.createRow(rowIndex);
        }
        return res;
    }

    public static void setCellValue(HSSFCell cell, Object obj) {
        if (cell != null) {
            if (obj instanceof Boolean) {
                cell.setCellValue(((Boolean)obj).booleanValue());
            }
            if (obj instanceof Number) {
                cell.setCellValue(((Double)obj).doubleValue());
            }
            if (obj instanceof String) {
                cell.setCellValue((RichTextString)new HSSFRichTextString(obj.toString()));
            }
        }
    }

    public static void setCellValueString(HSSFCell cell, String val) {
        if (cell != null && val != null) {
            cell.setCellValue((RichTextString)new HSSFRichTextString(val));
        }
    }

    public static HSSFCell getOrCreateCell(HSSFRow row, short i) {
        HSSFCell res = null;
        if (row != null && i >= 0 && (res = row.getCell(i)) == null) {
            res = row.createCell(i);
        }
        return res;
    }

    public static HSSFWorkbook getWorkbook(File workBook) throws IOException {
        HSSFWorkbook res = null;
        if (workBook != null && workBook.exists() && !workBook.isDirectory()) {
            if (map.containsKey(workBook.getAbsolutePath())) {
                res = map.get(workBook.getAbsolutePath());
            } else {
                res = new HSSFWorkbook((InputStream)new FileInputStream(workBook));
                map.put(workBook.getAbsolutePath(), res);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveWorkbook(HSSFWorkbook wb, File workBook) {
        if (wb != null && workBook != null) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(workBook);
                wb.write((OutputStream)fos);
                fos.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

