/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls.poi.parser;

import java.io.File;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ru.infor.frc.report.builder.xls.XLSParser;
import ru.infor.frc.report.builder.xls.poi.parser.CommonXLSOperation;
import ru.infor.frc.report.builder.xls.poi.parser.ParameterExctractor;
import ru.infor.frc.report.builder.xls.poi.parser.PatternExctractor;
import ru.infor.frc.report.builder.xls.schema.XLSTemplateSchema;

public class POIParser
implements XLSParser {
    private static Logger logger = Logger.getLogger(XLSParser.class);

    @Override
    public XLSTemplateSchema parseFile(File xlsFile) {
        XLSTemplateSchema res = null;
        if (xlsFile != null) {
            HSSFWorkbook workbook = null;
            try {
                workbook = CommonXLSOperation.getWorkbook(xlsFile);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (workbook != null) {
                res = new XLSTemplateSchema();
                HSSFSheet sheet = workbook.getSheet("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
                res = ParameterExctractor.getParameterFromSheet(sheet, res);
                sheet = workbook.getSheet("\u0428\u0430\u0431\u043b\u043e\u043d");
                res = PatternExctractor.getPatternFromSheet(sheet, res);
                res.setSrcBookFile(xlsFile);
                res.setSrcSheetName("\u0428\u0430\u0431\u043b\u043e\u043d");
            }
        }
        return res;
    }

    @Override
    public XLSTemplateSchema parseFile(String xlsFile) {
        return this.parseFile(new File(xlsFile));
    }
}

