/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls.poi.parser;

import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import ru.infor.frc.report.builder.xls.CommonUtils;
import ru.infor.frc.report.builder.xls.FRCFunction;
import ru.infor.frc.report.builder.xls.poi.parser.CommonXLSOperation;
import ru.infor.frc.report.builder.xls.schema.XLSTemplateSchema;

public class PatternExctractor {
    public static XLSTemplateSchema getPatternFromSheet(HSSFSheet sheet, XLSTemplateSchema res) {
        if (sheet != null) {
            for (int i = sheet.getFirstRowNum(); i < sheet.getLastRowNum(); ++i) {
                HSSFRow row = CommonXLSOperation.getRow(sheet, i);
                if (row == null) continue;
                ArrayList<String> rowPatterns = PatternExctractor.getRowPatterns(row);
                CommonUtils.getPattern(res, rowPatterns, row, PatternExctractor.getRowFormula(row));
            }
        }
        return res;
    }

    private static ArrayList<FRCFunction> getRowFormula(HSSFRow row) {
        ArrayList<FRCFunction> res = new ArrayList<FRCFunction>();
        if (row != null) {
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                HSSFCell cell = CommonXLSOperation.getCell(row, i);
                String cellValueString = CommonXLSOperation.getCellValueString(cell);
                if (!cellValueString.startsWith("%")) continue;
                res.add(new FRCFunction(cellValueString));
            }
        }
        return res;
    }

    private static ArrayList<String> getRowPatterns(HSSFRow row) {
        ArrayList<String> res = new ArrayList<String>();
        boolean q = false;
        if (row != null) {
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                HSSFCell cell = CommonXLSOperation.getCell(row, i);
                String cellValueString = CommonXLSOperation.getCellValueString(cell);
                if (q) {
                    res.add(cellValueString);
                    continue;
                }
                if (!cellValueString.startsWith("#")) continue;
                q = true;
                res.add(cellValueString.substring(1));
            }
        }
        return res;
    }
}

