/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls.vba.datawriter;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.log4j.Logger;
import ru.infor.frc.report.builder.data.ReportData;
import ru.infor.frc.report.builder.data.ReportParameter;
import ru.infor.frc.report.builder.xls.PrintingRows;
import ru.infor.frc.report.builder.xls.XLSBuilder;
import ru.infor.frc.report.builder.xls.XLSDataWriter;
import ru.infor.frc.report.builder.xls.schema.ParameterTemplateSchema;
import ru.infor.frc.report.builder.xls.schema.XLSTemplateSchema;
import ru.infor.frc.report.utils.FileCopyUtils;
import ru.infor.frc.report.utils.windows.CommonVBAOperation;

public class VBADataWriter
implements XLSDataWriter {
    private static Logger logger = Logger.getLogger(VBADataWriter.class);
    private static final String MacrosXLSResourceString = "resource/Macro.xls";
    private static final String ExeMacrosResourceString = "resource/ExeMacrosExcel.exe";
    private static final String MACROS_PREFIX = "Macro";
    private static final String LAUNCHER_PREFIX = "ExeMacrosExcel";
    private static final String EXE_SUFFIX = ".exe";
    private static final String XLS_SUFFIX = ".xls";
    private File macros_xls = null;
    private File macros_launcher = null;

    public VBADataWriter() {
        try {
            InputStream in = this.getClass().getResourceAsStream(MacrosXLSResourceString);
            this.macros_xls = new File(XLSBuilder.TEMP_DIR_FILE, "Macro.xls");
            FileCopyUtils.copy(in, this.macros_xls);
            in = this.getClass().getResourceAsStream(ExeMacrosResourceString);
            this.macros_launcher = new File(XLSBuilder.TEMP_DIR_FILE, "ExeMacrosExcel.exe");
            FileCopyUtils.copy(in, this.macros_launcher);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.macros_xls = null;
            this.macros_launcher = null;
        }
    }

    @Override
    public File writeDataOnSheet(XLSTemplateSchema parsedTemplate, File workBook, String sheetName, ReportData reportData) {
        File res = workBook;
        if (workBook != null && sheetName != null && reportData != null) {
            String vbScript = CommonVBAOperation.generateScript(workBook.getAbsolutePath(), sheetName, reportData);
            CommonVBAOperation.runVBAScript(vbScript);
            try {
                this.runMacros(workBook.getAbsolutePath());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }

    private void runMacros(String xlsFile) throws Exception {
        if (this.macros_xls == null || !this.macros_xls.exists() || this.macros_launcher == null || !this.macros_launcher.exists()) {
            throw new Exception("Can't find the file with macros.");
        }
        StringBuilder sb = new StringBuilder(5);
        sb.append(this.macros_launcher.getAbsolutePath()).append(" \"").append(xlsFile).append("\" \"").append(this.macros_xls.getAbsolutePath()).append("\"");
        CommonVBAOperation.runProcess(sb.toString());
    }

    @Override
    public void writeDataOnSheet(XLSTemplateSchema parsedTemplate, File workBook, String sheetName, List<PrintingRows> printingRows) {
        logger.error((Object)"Method printDataOnSheet() not supported", new Throwable());
    }

    @Override
    public void syncColumnWidth(XLSTemplateSchema parsedTemplate, File dstBookFile, String dstSheetName) {
        logger.error((Object)"Method syncColumnWidth() not supported", new Throwable());
    }

    @Override
    public void writeParameter(XLSTemplateSchema parsedTemplate, File workBook, String sheetName, List<ReportParameter> parameters) {
        if (workBook != null && sheetName != null && parameters != null && parameters.size() > 0) {
            ParameterTemplateSchema parameterTemplateSchema = parsedTemplate.getParameterTemplateSchema();
            for (ReportParameter reportParameter : parameters) {
                parameterTemplateSchema.addParameter(null, reportParameter.getName(), reportParameter.getValue());
            }
            String vbScript = CommonVBAOperation.generatePasteParametersScript(parameterTemplateSchema, workBook.getAbsolutePath(), sheetName, parameters);
            CommonVBAOperation.runVBAScript(vbScript);
        }
    }
}

