/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls.vba.parser;

import java.util.ArrayList;
import jxl.Cell;
import jxl.Sheet;
import ru.infor.frc.report.builder.xls.CommonUtils;
import ru.infor.frc.report.builder.xls.schema.ParameterTemplateSchema;
import ru.infor.frc.report.builder.xls.schema.XLSTemplateSchema;
import ru.infor.frc.report.builder.xls.vba.parser.RowInformation;

public class CommonJXLOperation {
    public static ParameterTemplateSchema parseParameterSheet(Sheet sheet) {
        ParameterTemplateSchema res = null;
        if (sheet != null) {
            res = new ParameterTemplateSchema();
            int rowCount = sheet.getRows();
            for (int i = 0; i < rowCount; ++i) {
                Cell[] rowCells = sheet.getRow(i);
                if (rowCells == null) continue;
                for (int j = 0; j < rowCells.length; ++j) {
                    String contents;
                    Cell cell = rowCells[j];
                    if (cell == null || !(contents = cell.getContents()).startsWith("$")) continue;
                    contents = contents.substring(1);
                    if (rowCells.length > j + 1) {
                        Cell vals = rowCells[j + 1];
                        if (vals == null) continue;
                        res.addParameter(i + 1, cell.getContents().substring(1), vals.getContents());
                        continue;
                    }
                    res.addParameter(i, cell.getContents().substring(1), "");
                }
            }
        }
        return res;
    }

    public static ArrayList<Integer> getColumnWidth(Sheet sheet) {
        ArrayList<Integer> res = null;
        if (sheet != null) {
            res = new ArrayList<Integer>();
            int columnsCount = sheet.getColumns();
            for (int i = 0; i < columnsCount; ++i) {
                res.add(sheet.getColumnView(i).getSize());
            }
        }
        return res;
    }

    public static XLSTemplateSchema parsePatternSheet(XLSTemplateSchema template, Sheet sheet) {
        XLSTemplateSchema res = template;
        if (sheet != null) {
            if (template == null) {
                res = new XLSTemplateSchema();
            }
            int rowsCount = sheet.getRows();
            for (int i = 0; i < rowsCount; ++i) {
                Cell[] row = sheet.getRow(i);
                ArrayList<String> pat = CommonJXLOperation.getPatternWords(row);
                RowInformation information = new RowInformation();
                information.setRowIndex(i);
                information.setColumnCount(CommonJXLOperation.getSharpColumn(row));
                CommonUtils.getPattern(res, pat, information, null);
            }
        }
        return res;
    }

    private static int getSharpColumn(Cell[] row) {
        int res = -1;
        if (row != null) {
            for (int i = 0; i < row.length; ++i) {
                if (row[i] == null || !row[i].getContents().startsWith("#")) continue;
                res = i - 1;
                break;
            }
        }
        return res;
    }

    private static ArrayList<String> getPatternWords(Cell[] row) {
        ArrayList<String> res = new ArrayList<String>();
        if (row != null) {
            boolean b = false;
            for (int i = 0; i < row.length; ++i) {
                Cell cell = row[i];
                if (cell == null) continue;
                if (b) {
                    res.add(cell.getContents());
                }
                if (b || !cell.getContents().startsWith("#")) continue;
                b = true;
                res.add(cell.getContents().substring(1));
            }
        }
        return res;
    }
}

