/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.builder.xls.vba.parser;

import java.io.File;
import java.io.IOException;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.apache.log4j.Logger;
import ru.infor.frc.report.builder.xls.XLSParser;
import ru.infor.frc.report.builder.xls.schema.XLSTemplateSchema;
import ru.infor.frc.report.builder.xls.vba.parser.CommonJXLOperation;

public class JXLParser
implements XLSParser {
    private static Logger logger = Logger.getLogger(JXLParser.class);

    @Override
    public XLSTemplateSchema parseFile(String xlsFile) {
        if (xlsFile == null || xlsFile.isEmpty()) {
            return null;
        }
        return this.parseFile(new File(xlsFile));
    }

    @Override
    public XLSTemplateSchema parseFile(File xlsFile) {
        XLSTemplateSchema res = null;
        if (xlsFile != null && xlsFile.exists()) {
            res = new XLSTemplateSchema();
            try {
                Workbook workbook = Workbook.getWorkbook((File)xlsFile);
                Sheet sheet = null;
                sheet = workbook.getSheet("\u0428\u0430\u0431\u043b\u043e\u043d");
                if (sheet != null) {
                    res.setColumnWidth(CommonJXLOperation.getColumnWidth(sheet));
                    res = CommonJXLOperation.parsePatternSheet(res, sheet);
                    res.setSrcBookFile(xlsFile);
                    res.setSrcSheetName("\u0428\u0430\u0431\u043b\u043e\u043d");
                }
                if ((sheet = workbook.getSheet("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b")) != null) {
                    res.setParameterTemplateSchema(CommonJXLOperation.parseParameterSheet(sheet));
                }
            }
            catch (BiffException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }
}

