/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.print;

import java.io.File;
import java.util.Properties;
import ru.infor.frc.report.print.Printer;
import ru.infor.frc.report.utils.windows.CommonVBAOperation;

public class WindowsPrinter
extends Printer {
    private static final WindowsPrinter _this = new WindowsPrinter();

    protected WindowsPrinter() {
    }

    @Override
    public void printFile(File templateFile, Properties printingProperty) {
        if (templateFile != null && templateFile.exists()) {
            String printingParameter = this.createParameterString(null);
            String script = CommonVBAOperation.generatePrintReportScript(templateFile.getAbsolutePath(), printingParameter);
            CommonVBAOperation.runVBAScript(script);
        }
    }

    public String createParameterString(Properties printingProperty) {
        String res = "";
        StringBuilder builder = new StringBuilder();
        if (printingProperty != null) {
            builder.append(printingProperty.getProperty("printer.from", "\"1\"")).append(",").append(" ");
            builder.append(printingProperty.getProperty("printer.to", "\"100\"")).append(",").append(" ");
            builder.append(printingProperty.getProperty("printer.copies", "\"1\"")).append(",").append(" ");
            builder.append(printingProperty.getProperty("printer.preview", "\"FALSE\"")).append(",").append(" ");
            builder.append("\"").append(printingProperty.getProperty("printer.activeprinter", Printer.getDefaultPrinterName())).append("\"").append(",").append(" ");
            builder.append(printingProperty.getProperty("printer.printtofile", "\"FALSE\"")).append(",").append(" ");
            builder.append(printingProperty.getProperty("printer.collate", "\"FALSE\"")).append(",").append(" ");
            builder.append(printingProperty.getProperty("printer.prtofilename", "\"\"")).append(",").append(" ");
            builder.append(printingProperty.getProperty("printer.ignoreprintareas", "\"FALSE\"")).append(" ");
        }
        res = builder.toString();
        return res;
    }

    public static WindowsPrinter getInstance() {
        return _this;
    }
}

