/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class FileCopyUtils {
    static Logger logger = Logger.getLogger(FileCopyUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, File dest) {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(dest);
                FileCopyUtils.copy(in, (OutputStream)out);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len = 0;
        byte[] data = new byte[8192];
        while ((len = in.read(data)) > 0) {
            out.write(data, 0, len);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, OutputStream dest) {
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(source);
                FileCopyUtils.copy((InputStream)in, dest);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                dest.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String sourceName, OutputStream dest) {
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(sourceName);
                FileCopyUtils.copy((InputStream)in, dest);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                dest.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStrToFile(String str, File dest) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes("UTF-8"));
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest);
            FileCopyUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File source) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
            FileCopyUtils.copy((InputStream)in, (OutputStream)out);
            String string = out.toString("UTF-8");
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void saveToFile(String fileName, String message) {
        FileCopyUtils.saveToFile(new File(fileName), message);
    }

    public static void saveToFile(File outputFile, String message) {
        try {
            FileWriter out = new FileWriter(outputFile);
            out.write(message);
            out.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public static void viewHtmlFile(String fileName) {
        if (fileName == null) {
            logger.error((Object)"File name is null!");
        } else {
            String osName = System.getProperty("os.name");
            if (osName.equalsIgnoreCase("Windows XP")) {
                try {
                    Runtime.getRuntime().exec("rundll32 SHELL32.DLL,ShellExec_RunDLL " + fileName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean writeToFile(String fileName, String dataLine, boolean isAppendMode, boolean isNewLine) {
        return FileCopyUtils.writeToFile(fileName, dataLine, isAppendMode, isNewLine, true);
    }

    public static boolean writeToFile(String fileName, String dataLine, boolean isAppendMode, boolean isNewLine, boolean isDos) {
        if (isNewLine) {
            dataLine = "\n" + dataLine;
        }
        try {
            File outFile = new File(fileName);
            FileOutputStream os = isAppendMode ? new FileOutputStream(fileName, true) : new FileOutputStream(outFile);
            if (isDos) {
                ((OutputStream)os).write(dataLine.getBytes("CP1251"));
            } else {
                ((OutputStream)os).write(dataLine.getBytes("CP866"));
            }
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static void main(String[] arg0) throws Exception {
        System.out.println(FileCopyUtils.readFileToString(new File("1.xml")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToBytes(InputStream in) throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
            FileCopyUtils.copy(in, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

