/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.utils;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import ru.infor.frc.report.print.WindowsPrinter;
import ru.infor.frc.report.utils.OSUtils;

public class FileUtil {
    private static final Logger logger = Logger.getLogger(FileUtil.class);

    public static boolean printFile(File templateFile, Properties printingProperty) {
        boolean res = false;
        if (OSUtils.isWindowsOS()) {
            WindowsPrinter.getInstance().printFile(templateFile, printingProperty);
        }
        return res;
    }

    public static boolean openFile(File templateFile, Properties afterBuildActionProperties) {
        boolean res = false;
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(templateFile);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            logger.error((Object)"Desktop unsupported.");
        }
        return res;
    }

    public static String getFileExtention(String fileName) {
        int of;
        if (fileName != null && !fileName.isEmpty() && (of = fileName.lastIndexOf(".")) > 0) {
            return fileName.substring(of + 1);
        }
        return null;
    }
}

