/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.report.utils.windows;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.infor.frc.report.builder.data.QueryResult;
import ru.infor.frc.report.builder.data.QueryResultRow;
import ru.infor.frc.report.builder.data.ReportData;
import ru.infor.frc.report.builder.data.ReportParameter;
import ru.infor.frc.report.builder.xls.XLSBuilder;
import ru.infor.frc.report.builder.xls.schema.ParameterTemplateSchema;
import ru.infor.frc.report.builder.xls.schema.XLSTemplateSchema;
import ru.infor.frc.report.utils.FileCopyUtils;
import ru.infor.frc.report.utils.FileUtil;
import ru.infor.frc.xls.builder.PrintingRow;

public class CommonVBAOperation {
    private static final String DataXLSPath = "resource/";
    private static final String SCRIPT_PREFIX = "scrp";
    private static final String VBS_SUFFIX = ".vbs";
    private static final String digits = "(\\p{Digit}+)";
    private static final String doubleS = "(\\p{Digit}+)\\.(\\p{Digit}+)";
    private static final Pattern pattern = Pattern.compile("(\\p{Digit}+)\\.(\\p{Digit}+)");
    private static final String XLS_FILE_SUFFIX = "xls";
    private static final String DOC_FILE_SUFFIX = "doc";
    private static Logger logger = Logger.getLogger(CommonVBAOperation.class);
    private static CommonVBAOperation operation = null;
    private String printRow;
    private String openBookTemplate = this.getTemplate("openBook.template");
    private String closeBookTemplate = this.getTemplate("closeBook.template");
    private String createObjectApplicationTemplate;
    private String xlsPrintTemplate;
    private String docPrintTemplate;

    private CommonVBAOperation() {
        this.printRow = this.getTemplate("printRow.template");
        this.createObjectApplicationTemplate = this.getTemplate("createObjectApplication.template");
        this.xlsPrintTemplate = this.getTemplate("xlsPrint.template");
        this.docPrintTemplate = this.getTemplate("docPrint.template");
    }

    public static CommonVBAOperation getInstatnce() {
        if (operation == null) {
            operation = new CommonVBAOperation();
        }
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTemplate(String name) {
        InputStream in;
        String res = null;
        if (name != null && !name.isEmpty() && (in = this.getClass().getResourceAsStream(DataXLSPath + name)) != null) {
            try {
                byte[] data = new byte[in.available()];
                in.read(data);
                res = new String(data);
                in.close();
                in = null;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    in = null;
                }
            }
        }
        return res;
    }

    public static String generateScript(String workbookPath, String sheetName, ReportData reportData) {
        StringBuilder sb = new StringBuilder(0);
        if (workbookPath != null && !workbookPath.isEmpty() && sheetName != null && !sheetName.isEmpty() && reportData != null) {
            sb.append(CommonVBAOperation.generateOpenBook(workbookPath, sheetName));
            int column = 1;
            ArrayList<QueryResult> queries = reportData.getQueries();
            for (int i = 0; i < queries.size(); ++i) {
                int index = 1;
                sb.append(CommonVBAOperation.generatePrintRow(index, column, queries.get(i).getColumnName().toArray(new String[queries.get(i).getColumnName().size()])));
                ++index;
                ArrayList<QueryResultRow> rows = queries.get(i).getRows();
                for (int j = 0; j < rows.size(); ++j) {
                    ArrayList<String> columnValues = rows.get(j).getColumnValues();
                    sb.append(CommonVBAOperation.generatePrintRow(index, column, columnValues.toArray(new String[columnValues.size()])));
                    ++index;
                }
                column = column + queries.get(i).getColumnName().size() + 1;
            }
            sb.append(CommonVBAOperation.generateCloseBook(workbookPath));
        }
        return sb.toString();
    }

    private static String formatSingleString(String value) {
        if (value != null) {
            value = value.replaceAll("\"", "'");
            value = value.replaceAll("\\u000A|\\u000D|\\u000C|\\u0007|\\u001B|\\u0009", "");
        } else {
            value = "";
        }
        return value;
    }

    private static String[] formatStrings(String[] columnValues) {
        for (int k = 0; k < columnValues.length; ++k) {
            columnValues[k] = CommonVBAOperation.formatSingleString(columnValues[k]);
        }
        return columnValues;
    }

    private static String generatePrintRow(int row, int columnD, String[] strings) {
        StringBuilder sb = new StringBuilder();
        String rowStr = String.valueOf(row);
        strings = CommonVBAOperation.formatStrings(strings);
        if (rowStr != null && !rowStr.isEmpty() && strings != null) {
            MessageFormat mf = new MessageFormat(CommonVBAOperation.getInstatnce().printRow);
            for (int i = 0; i < strings.length; ++i) {
                String column = String.valueOf(i + 1 + columnD);
                String value = CommonVBAOperation.prepareData(strings[i]);
                sb.append(mf.format(new Object[]{rowStr, column, value}));
            }
        }
        return sb.toString();
    }

    public static String prepareData(String old) {
        String res = old;
        if (res != null && !pattern.matcher(res = res.replaceAll(",", ".")).matches()) {
            res = "\"" + old + "\"";
        }
        return res;
    }

    private static String generateCloseBook(String workbookPath) {
        String res = null;
        if (workbookPath != null && !workbookPath.isEmpty()) {
            String fileName = workbookPath.substring(workbookPath.lastIndexOf(File.separator) + 1);
            MessageFormat mf = new MessageFormat(CommonVBAOperation.getInstatnce().closeBookTemplate);
            res = mf.format(new Object[]{fileName});
        }
        return res;
    }

    private static String generateOpenBook(String workbookPath, String sheetName) {
        String res = null;
        if (workbookPath != null && !workbookPath.isEmpty()) {
            String fileName = workbookPath.substring(workbookPath.lastIndexOf(File.separator) + 1);
            MessageFormat mf = new MessageFormat(CommonVBAOperation.getInstatnce().openBookTemplate);
            res = mf.format(new Object[]{workbookPath, fileName, sheetName});
        }
        return res;
    }

    public static String generateScript(String workBookPath, String sheetName, XLSTemplateSchema parsedTemplate, List<PrintingRow> list) {
        StringBuilder res = new StringBuilder();
        if (workBookPath != null && !workBookPath.isEmpty() && sheetName != null && !sheetName.isEmpty() && parsedTemplate != null && list != null) {
            res.append(CommonVBAOperation.generateOpenBook(workBookPath, sheetName));
            res.append(CommonVBAOperation.generateCloseBook(workBookPath));
        }
        return res.toString();
    }

    public static String generatePasteParametersScript(ParameterTemplateSchema parameterTemplateSchema, String xlsFile, String sheetName, List<ReportParameter> parameters) {
        StringBuilder res = new StringBuilder();
        if (xlsFile != null && !xlsFile.isEmpty() && sheetName != null && !sheetName.isEmpty() && parameters != null && parameters.size() > 0) {
            res.append(CommonVBAOperation.generateOpenBook(xlsFile, sheetName));
            Collection<String> paramName = parameterTemplateSchema.getParameterNameSet();
            for (String name : paramName) {
                res.append(CommonVBAOperation.generatePrintRow(parameterTemplateSchema.getParameterIndex(name), 0, new String[]{"$" + name, parameterTemplateSchema.getValueByName(name)}));
            }
            res.append(CommonVBAOperation.generateCloseBook(xlsFile));
        }
        return res.toString();
    }

    public static String generatePrintReportScript(String workbookPath, String printingParameter) {
        String res = null;
        if (workbookPath != null) {
            if (printingParameter == null) {
                printingParameter = "";
            }
            String vbaParam = "objXL";
            String extention = FileUtil.getFileExtention(workbookPath);
            String applicationType = CommonVBAOperation.getApplication(extention);
            MessageFormat mf = new MessageFormat(CommonVBAOperation.getInstatnce().createObjectApplicationTemplate);
            String printingFragment = CommonVBAOperation.getPrintFragment(vbaParam, extention, workbookPath, printingParameter);
            res = mf.format(new Object[]{vbaParam, applicationType, printingFragment});
        }
        return res;
    }

    private static String getPrintFragment(String vbaParam, String extention, String workbookPath, String printingParameter) {
        String res = "";
        if (workbookPath != null) {
            if (printingParameter == null) {
                printingParameter = "";
            }
            MessageFormat mf = new MessageFormat(CommonVBAOperation.getInstatnce().getPrintTemplate(extention));
            String fileName = workbookPath.substring(workbookPath.lastIndexOf(File.separator) + 1);
            res = mf.format(new Object[]{vbaParam, workbookPath, fileName, printingParameter});
        }
        return res;
    }

    private String getPrintTemplate(String extention) {
        if (extention != null) {
            if (extention.equalsIgnoreCase(XLS_FILE_SUFFIX)) {
                return this.xlsPrintTemplate;
            }
            if (extention.equalsIgnoreCase(DOC_FILE_SUFFIX)) {
                return this.docPrintTemplate;
            }
        }
        return "";
    }

    private static String getApplication(String fileExtention) {
        String res = "Excel.Application";
        if (fileExtention != null && fileExtention.equalsIgnoreCase(DOC_FILE_SUFFIX)) {
            res = "Word.Application";
        }
        return res;
    }

    public static void runVBAScript(String script) {
        try {
            File outputFile = File.createTempFile(SCRIPT_PREFIX, VBS_SUFFIX, XLSBuilder.TEMP_DIR_FILE);
            outputFile.deleteOnExit();
            FileCopyUtils.writeToFile(outputFile.getAbsolutePath(), script, false, false, true);
            CommonVBAOperation.runProcess("wscript.exe " + outputFile.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void runProcess(String command) {
        if (command != null && !command.isEmpty()) {
            try {
                Process process = Runtime.getRuntime().exec(command);
                if (process.waitFor() != 0) {
                    InputStream inputStream;
                    logger.info((Object)("Some error occured while " + command + " was processing."));
                    InputStream errorStream = process.getErrorStream();
                    if (errorStream != null && errorStream.available() != 0) {
                        byte[] data = new byte[errorStream.available()];
                        errorStream.read(data);
                        logger.error((Object)new String(data));
                    }
                    if ((inputStream = process.getInputStream()) != null && inputStream.available() != 0) {
                        byte[] data = new byte[inputStream.available()];
                        inputStream.read(data);
                        logger.debug((Object)new String(data));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

