/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.xls;

import java.io.File;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ru.infor.frc.report.builder.data.ReportData;
import ru.infor.frc.xls.ReportDataTableModel;
import ru.infor.frc.xls.ReportStateListener;
import ru.infor.frc.xls.XLSFormatWriter;
import ru.infor.frc.xls.XLSFormatingParser;
import ru.infor.frc.xls.builder.PrintingRow;
import ru.infor.frc.xls.builder.ReportBuilder;
import ru.infor.frc.xls.schema.XLSTemplateSchema;
import ru.infor.xls.XLSSimpleWriter;
import ru.infor.xls.utils.WorkbookUtils;

public class FRCReporter {
    public static File buildReport(String fileName, ReportData data, ReportStateListener stateListener) {
        File res = null;
        HSSFWorkbook workbook = WorkbookUtils.openWorkbook(fileName, false);
        XLSTemplateSchema schema = XLSFormatingParser.parse(workbook);
        HSSFSheet workSheet = WorkbookUtils.recreateSheet(workbook, "\u0420\u0430\u0431\u043e\u0447\u0438\u0439");
        XLSSimpleWriter.write(new ReportDataTableModel(data), workSheet);
        ArrayList<PrintingRow> result = ReportBuilder.build(schema, data);
        for (PrintingRow printingRow : result) {
            System.out.println(printingRow);
        }
        if (stateListener != null) {
            result = stateListener.beforeWriteOnSheet(result);
        }
        XLSFormatWriter.writeParameters(schema, workbook, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        XLSFormatWriter.write(schema, result, workbook, "\u041e\u0442\u0447\u0435\u0442");
        if (stateListener != null) {
            stateListener.afterWriteOnSheet(workbook);
        }
        WorkbookUtils.showOnly(workbook, "\u041e\u0442\u0447\u0435\u0442");
        res = WorkbookUtils.save(workbook, fileName);
        return res;
    }
}

