/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.xls;

import java.util.ArrayList;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import ru.infor.frc.report.builder.data.QueryResult;
import ru.infor.frc.report.builder.data.ReportData;

public class ReportDataTableModel
implements TableModel {
    private ReportData reportData = null;
    private static final String empty = "";

    public ReportDataTableModel(ReportData data) {
        this.reportData = data;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        ArrayList<QueryResult> queries;
        int res = 0;
        if (this.reportData != null && (queries = this.reportData.getQueries()) != null) {
            for (QueryResult query : queries) {
                res += query.getColumnName().size();
            }
        }
        return res;
    }

    @Override
    public String getColumnName(int columnIndex) {
        ArrayList<QueryResult> queries;
        String res = null;
        if (this.reportData != null && (queries = this.reportData.getQueries()) != null) {
            for (int i = 0; i < queries.size(); ++i) {
                QueryResult query = queries.get(i);
                if (columnIndex < query.getColumnName().size()) {
                    res = query.getColumnName().get(columnIndex);
                    break;
                }
                columnIndex -= query.getColumnName().size();
            }
        }
        return res;
    }

    @Override
    public int getRowCount() {
        ArrayList<QueryResult> queries;
        int res = 0;
        if (this.reportData != null && (queries = this.reportData.getQueries()) != null) {
            for (QueryResult query : queries) {
                if (query.getRows().size() <= res) continue;
                res = query.getRows().size();
            }
        }
        return res;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ArrayList<QueryResult> queries;
        String res = empty;
        if (this.reportData != null && (queries = this.reportData.getQueries()) != null) {
            for (int i = 0; i < queries.size(); ++i) {
                QueryResult query = queries.get(i);
                if (columnIndex < query.getColumnName().size()) {
                    if (rowIndex >= query.getRows().size()) break;
                    res = query.getRows().get(rowIndex).getColumnValues().get(columnIndex);
                    break;
                }
                columnIndex -= query.getColumnName().size();
            }
        }
        return res;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }
}

