/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.xls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ru.infor.frc.xls.builder.PrintingRow;
import ru.infor.frc.xls.schema.ColumnProperty;
import ru.infor.frc.xls.schema.ParameterTemplateSchema;
import ru.infor.frc.xls.schema.XLSTemplateSchema;
import ru.infor.frc.xls.writer.WriterUtils;
import ru.infor.xls.utils.SheetUtils;
import ru.infor.xls.utils.WorkbookUtils;

public class XLSFormatWriter {
    public static void write(XLSTemplateSchema schema, ArrayList<PrintingRow> result, HSSFWorkbook workbook, String sheetName) {
        HSSFSheet sheet = WorkbookUtils.recreateSheet(workbook, sheetName);
        int rowIndex = 0;
        if (sheet != null && result != null) {
            HashSet<ColumnProperty> columnWidth = schema.getColumnWidth();
            for (ColumnProperty columnProperty : columnWidth) {
                sheet.setColumnWidth(columnProperty.getIndex(), columnProperty.getColumnWidth());
            }
            for (int i = 0; i < result.size(); ++i) {
                PrintingRow printingRow = result.get(i);
                ArrayList<HSSFRow> rows = printingRow.getRows();
                HashMap<String, String> parameter = printingRow.getParameter();
                HashMap<String, String> valuesMap = printingRow.getValuesMap();
                for (int j = 0; j < rows.size(); ++j) {
                    WriterUtils.writeRow(sheet, rowIndex, rows.get(j), parameter, valuesMap);
                    ++rowIndex;
                }
            }
        }
    }

    public static void writeParameters(XLSTemplateSchema schema, HSSFWorkbook workbook, String sheetName) {
        ParameterTemplateSchema parameterTS;
        HSSFSheet sheet = WorkbookUtils.getSheet(workbook, sheetName, true);
        if (sheet != null && (parameterTS = schema.getParameterTemplateSchema()) != null) {
            Collection<String> parameterNameSet = parameterTS.getParameterNameSet();
            for (String name : parameterNameSet) {
                Integer index = parameterTS.getParameterIndex(name);
                if (index < 0) continue;
                short c = 0;
                HSSFRow row = SheetUtils.getRow(sheet, index, true);
                for (short i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                    String value = SheetUtils.getCellStringValue(SheetUtils.getCell(row, i, false));
                    if (value == null || !value.equalsIgnoreCase(name)) continue;
                    c = i;
                    break;
                }
                HSSFCell cell = SheetUtils.getCell(sheet, index, c, true);
                cell.setCellValue(name);
                cell = SheetUtils.getCell(sheet, index, c + 1, true);
                cell.setCellValue(parameterTS.getValueByName(name));
            }
        }
    }
}

