/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.xls.builder;

import java.util.List;
import ru.infor.frc.xls.builder.FRCFunctionCalculater;

public class FRCFunction {
    private String functionString;
    private String signature;
    private String operand;

    public FRCFunction(String fun) {
        this.functionString = fun;
        this.signature = FRCFunction.getSignature(fun);
        this.operand = FRCFunction.getOperand(fun);
    }

    public String getSignature() {
        return this.signature;
    }

    public String getOperand() {
        return this.operand;
    }

    public String calculate(List<String> valuesList) {
        if ("sum".equalsIgnoreCase(this.signature)) {
            return FRCFunctionCalculater.summ(valuesList);
        }
        return valuesList.size() > 0 ? valuesList.get(0) : "";
    }

    public static String getSignature(String funString) {
        int i;
        String res = null;
        if (funString != null && !funString.isEmpty() && (i = funString.indexOf("(")) > 0) {
            res = funString.substring(0, i);
        }
        return res;
    }

    public static String getOperand(String funString) {
        String res = null;
        if (funString != null && !funString.isEmpty()) {
            int i = funString.indexOf("(");
            if (i > 0) {
                int j;
                if ((j = funString.indexOf(")", ++i)) > 0) {
                    res = funString.substring(i, j);
                }
            } else {
                res = funString.trim();
            }
            if (res.startsWith("%")) {
                res = res.substring(1);
            }
        }
        return res;
    }

    public String getFunctionString() {
        return this.functionString;
    }
}

