/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.xls.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.infor.frc.report.builder.data.QueryResult;
import ru.infor.frc.report.builder.data.QueryResultRow;
import ru.infor.frc.report.builder.data.ReportData;
import ru.infor.frc.report.builder.data.ReportParameter;
import ru.infor.frc.xls.builder.FRCFunction;
import ru.infor.frc.xls.builder.PrintingRow;
import ru.infor.frc.xls.schema.GroupTemplateSchema;
import ru.infor.frc.xls.schema.ParameterTemplateSchema;
import ru.infor.frc.xls.schema.QueryTemplateSchema;
import ru.infor.frc.xls.schema.XLSTemplateSchema;

public class ReportBuilder {
    public static ArrayList<PrintingRow> build(XLSTemplateSchema schema, ReportData data) {
        ArrayList<PrintingRow> res = new ArrayList<PrintingRow>();
        if (schema != null && data != null) {
            ReportBuilder.prepareData(data);
            HashMap<String, String> parameters = ReportBuilder.getParameters(schema, data);
            res.add(PrintingRow.getInstance("title", schema.getTitleRows(), parameters, null));
            ArrayList<QueryResult> queries = data.getQueries();
            HashMap<Integer, QueryResult> datasQueries = new HashMap<Integer, QueryResult>(queries.size());
            for (QueryResult queryResult : queries) {
                datasQueries.put(queryResult.getIndex(), queryResult);
            }
            HashMap<Integer, QueryTemplateSchema> schemasQueries = schema.getQueries();
            ArrayList<Integer> list = new ArrayList<Integer>(schemasQueries.keySet());
            Collections.sort(list);
            for (int i = 0; i < list.size(); ++i) {
                Integer index = list.get(i);
                QueryTemplateSchema query = schemasQueries.get(index);
                QueryResult queryResult = (QueryResult)datasQueries.get(index);
                String tag = "query".concat(".").concat(index.toString());
                res.addAll(ReportBuilder.buildQueriesPrintingRow(tag, query, queryResult, parameters));
            }
            res.add(PrintingRow.getInstance("end", schema.getEndRows(), parameters, null));
        }
        return res;
    }

    private static void prepareData(ReportData data) {
        if (data != null) {
            ArrayList<QueryResult> queries = data.getQueries();
            for (QueryResult query : queries) {
                ArrayList<String> columnName = query.getColumnName();
                ArrayList<String> columns = new ArrayList<String>(columnName.size());
                for (int i = 0; i < columnName.size(); ++i) {
                    columns.add(columnName.get(i).toLowerCase());
                }
                query.setColumnName(columns);
            }
        }
    }

    private static HashMap<String, String> getParameters(XLSTemplateSchema schema, ReportData data) {
        ParameterTemplateSchema parameterTemplateSchema = schema.getParameterTemplateSchema();
        ArrayList<ReportParameter> par = data.getParameters();
        for (ReportParameter reportParameter : par) {
            parameterTemplateSchema.addParameter(null, reportParameter.getName(), reportParameter.getValue());
        }
        Collection<String> parameterNameSet = parameterTemplateSchema.getParameterNameSet();
        HashMap<String, String> parameters = new HashMap<String, String>(parameterNameSet.size());
        for (String key : parameterNameSet) {
            parameters.put(key, parameterTemplateSchema.getValueByName(key));
        }
        return parameters;
    }

    private static Collection<PrintingRow> buildQueriesPrintingRow(String tag, QueryTemplateSchema query, QueryResult queryResult, HashMap<String, String> parameters) {
        ArrayList<PrintingRow> res = new ArrayList<PrintingRow>();
        if (query != null) {
            res.add(PrintingRow.getInstance(tag.concat(".").concat("title"), query.getTitleRows(), parameters, null));
            ArrayList<String> columnName = queryResult.getColumnName();
            ArrayList<QueryResultRow> listD = queryResult.getRows();
            res.addAll(ReportBuilder.grouping(tag, columnName, listD, query, 1));
            res.add(PrintingRow.getInstance(tag.concat(".").concat("end"), query.getEndRows(), parameters, null));
        }
        return res;
    }

    private static Collection<PrintingRow> grouping(String tag, ArrayList<String> columnNameList, List<QueryResultRow> list, QueryTemplateSchema query, Integer index) {
        ArrayList<PrintingRow> res = null;
        if (columnNameList != null && list != null && query != null) {
            res = new ArrayList<PrintingRow>(list.size());
            if (list.size() > 0) {
                if (index > query.getGroups().size()) {
                    for (int i = 0; i < list.size(); ++i) {
                        HashMap<String, String> map = ReportBuilder.getValuesMap(columnNameList, list.get(i).getColumnValues());
                        res.add(PrintingRow.getInstance(tag.concat("/.").concat("detail"), query.getDetailRows(), null, map));
                    }
                } else {
                    GroupTemplateSchema gr = query.getGroups().get(index);
                    String groupString = tag.concat(".").concat("gr").concat(".").concat(String.valueOf(index));
                    String startGroupString = groupString.concat(".").concat("head");
                    String endGroupString = groupString.concat(".").concat("end");
                    HashMap<String, String> map = new HashMap<String, String>();
                    res.add(PrintingRow.getInstance(startGroupString, gr.getTitleRows(), null, map));
                    HashSet<Object> obj = ReportBuilder.getColumn(gr.getColumns(), columnNameList, list.get(0).getColumnValues());
                    int start = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        HashSet<Object> newObj = ReportBuilder.getColumn(gr.getColumns(), columnNameList, list.get(i).getColumnValues());
                        if (!ReportBuilder.ObjectsNotEqual(obj, newObj)) continue;
                        ArrayList<QueryResultRow> subListD = new ArrayList<QueryResultRow>(list.subList(start, i));
                        map.putAll(ReportBuilder.getFunctionsResult(gr.getFunctions(), columnNameList, subListD));
                        res.addAll(ReportBuilder.grouping(tag, columnNameList, subListD, query, index + 1));
                        res.add(PrintingRow.getInstance(endGroupString, gr.getEndRows(), null, map));
                        map = new HashMap();
                        res.add(PrintingRow.getInstance(startGroupString, gr.getTitleRows(), null, map));
                        obj = newObj;
                        start = i;
                    }
                    map.putAll(ReportBuilder.getFunctionsResult(gr.getFunctions(), columnNameList, list.subList(start, list.size())));
                    res.addAll(ReportBuilder.grouping(tag, columnNameList, list.subList(start, list.size()), query, index + 1));
                    res.add(PrintingRow.getInstance(endGroupString, gr.getEndRows(), null, map));
                }
            }
        }
        return res;
    }

    private static HashMap<String, String> getFunctionsResult(ArrayList<String> functions, ArrayList<String> columnNameList, List<QueryResultRow> list) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String functionString : functions) {
            FRCFunction function = new FRCFunction(functionString);
            String columnName = function.getOperand();
            int index = columnNameList.indexOf(columnName);
            ArrayList<String> valuesList = new ArrayList<String>(list.size());
            if (index >= 0) {
                for (QueryResultRow queryResultRow : list) {
                    valuesList.add(queryResultRow.getColumnValues().get(index));
                }
            }
            String functionResult = function.calculate(valuesList);
            res.put(functionString, functionResult);
        }
        return res;
    }

    private static boolean ObjectsNotEqual(Set<Object> obj, Set<Object> newObj) {
        boolean eq = false;
        if (obj == null && newObj == null) {
            eq = true;
        }
        if (obj != null && newObj != null) {
            eq = ((Object)obj).hashCode() == ((Object)newObj).hashCode();
        }
        return !eq;
    }

    private static HashSet<Object> getColumn(ArrayList<String> groupColumns, ArrayList<String> columnNameList, ArrayList<String> columnValueList) {
        HashSet<Object> res = new HashSet<Object>();
        for (String columnName : groupColumns) {
            int index;
            if (columnName.startsWith("%")) {
                columnName = columnName.substring(1);
            }
            if ((index = columnNameList.indexOf(columnName)) < 0) continue;
            res.add(columnValueList.get(index));
        }
        return res;
    }

    private static HashMap<String, String> getValuesMap(ArrayList<String> columnName, ArrayList<String> columnValues) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (int i = 0; i < columnName.size(); ++i) {
            res.put(columnName.get(i), columnValues.get(i));
        }
        return res;
    }
}

