/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.xls.parser;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import ru.infor.frc.xls.schema.XLSTemplateSchema;
import ru.infor.xls.utils.SheetUtils;

public class ParameterParser {
    private ParameterParser() {
    }

    public static XLSTemplateSchema parseParameterSheet(HSSFSheet sheet, XLSTemplateSchema schema) {
        if (sheet != null) {
            for (int i = sheet.getFirstRowNum(); i < sheet.getLastRowNum() + 1; ++i) {
                HSSFRow row = SheetUtils.getRow(sheet, i, false);
                if (row == null) continue;
                for (int j = row.getFirstCellNum(); j < row.getLastCellNum() + 1; ++j) {
                    String parameterName;
                    HSSFCell cell = SheetUtils.getCell(row, j, false);
                    if (cell == null || (parameterName = SheetUtils.getCellStringValue(cell)) == null || !parameterName.startsWith("$")) continue;
                    String parameterValue = SheetUtils.getCellStringValue(SheetUtils.getCell(row, j + 1, true));
                    schema.getParameterTemplateSchema().addParameter(i, parameterName, parameterValue);
                }
            }
        }
        return schema;
    }
}

