/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.xls.parser;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import ru.infor.frc.xls.parser.RowPatternData;
import ru.infor.frc.xls.schema.ColumnProperty;
import ru.infor.frc.xls.schema.GroupTemplateSchema;
import ru.infor.frc.xls.schema.QueryTemplateSchema;
import ru.infor.frc.xls.schema.XLSTemplateSchema;
import ru.infor.xls.utils.SheetUtils;

public class PatternParser {
    private PatternParser() {
    }

    public static XLSTemplateSchema parsePatternSheet(HSSFSheet sheet, XLSTemplateSchema schema) {
        if (sheet != null && schema != null) {
            int q = SheetUtils.getPatternColumnIndex(sheet) + 1;
            schema.setPatternColumnIndex(q);
            HashSet<ColumnProperty> cSet = new HashSet<ColumnProperty>(q);
            for (int i = sheet.getLeftCol(); i < q; ++i) {
                int width = sheet.getColumnWidth(i);
                cSet.add(ColumnProperty.getInstance(i, width));
            }
            schema.setColumnWidth(cSet);
            for (int rowI = sheet.getFirstRowNum(); rowI < sheet.getLastRowNum(); ++rowI) {
                HSSFRow row = SheetUtils.getRow(sheet, rowI, false);
                schema = PatternParser.parseRow(row, schema);
            }
        }
        return schema;
    }

    private static XLSTemplateSchema parseRow(HSSFRow row, XLSTemplateSchema schema) {
        if (row != null) {
            String qName;
            RowPatternData patternData = new RowPatternData(row);
            String str = patternData.nextPattern();
            if ("title".equals(str)) {
                schema.getTitleRows().add(row);
            }
            if ("end".equals(str)) {
                schema.getEndRows().add(row);
            }
            if ("query".equals(str) && (qName = patternData.nextPattern()) != null) {
                QueryTemplateSchema query = schema.getQueryByName(Integer.parseInt(qName), true);
                PatternParser.updateQuery(query, patternData);
            }
        }
        return schema;
    }

    private static QueryTemplateSchema updateQuery(QueryTemplateSchema query, RowPatternData patternData) {
        if (query != null) {
            String gName;
            query.getFunctions().addAll(patternData.getFunctions());
            String str = patternData.nextPattern();
            if ("title".equals(str)) {
                query.getTitleRows().add(patternData.getRow());
            }
            if ("end".equals(str)) {
                query.getEndRows().add(patternData.getRow());
            }
            if ("detail".equals(str)) {
                query.getDetailRows().add(patternData.getRow());
            }
            if ("gr".equals(str) && (gName = patternData.nextPattern()) != null) {
                GroupTemplateSchema group = query.getGroupByIndex(Integer.parseInt(gName), true);
                PatternParser.updateGroup(group, patternData);
            }
        }
        return query;
    }

    private static GroupTemplateSchema updateGroup(GroupTemplateSchema group, RowPatternData patternData) {
        if (group != null) {
            group.getFunctions().addAll(patternData.getFunctions());
            String str = patternData.nextPattern();
            if ("head".equals(str)) {
                group.getTitleRows().add(patternData.getRow());
            }
            if ("end".equals(str)) {
                group.getEndRows().add(patternData.getRow());
            }
            if ("column".equals(str)) {
                ArrayList<String> columns = new ArrayList<String>(patternData.getPatterns());
                group.setColumns(columns);
            }
        }
        return group;
    }
}

