/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.xls.parser;

import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFRow;
import ru.infor.xls.utils.SheetUtils;

public class RowPatternData {
    private HSSFRow row = null;
    private ArrayList<String> patterns = new ArrayList();
    private ArrayList<String> functions = new ArrayList();

    public RowPatternData(HSSFRow row) {
        if (row == null) {
            throw new NullPointerException("Row can't be null.");
        }
        this.row = row;
        for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
            String cellValue = SheetUtils.getCellStringValue(SheetUtils.getCell(row, i, false));
            if (cellValue == null) continue;
            if (cellValue.startsWith("%")) {
                this.getFunctions().add(this.format(cellValue));
            }
            if (!cellValue.startsWith("#")) continue;
            this.getPatterns().add(this.format(cellValue));
            for (int j = i + 1; j < row.getLastCellNum(); ++j) {
                cellValue = SheetUtils.getCellStringValue(SheetUtils.getCell(row, j, false));
                if (cellValue == null) continue;
                this.getPatterns().add(cellValue.toLowerCase());
            }
            break;
        }
    }

    public ArrayList<String> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(ArrayList<String> patterns) {
        this.patterns = patterns;
    }

    public ArrayList<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(ArrayList<String> functions) {
        this.functions = functions;
    }

    public HSSFRow getRow() {
        return this.row;
    }

    public String format(String str) {
        return str.substring(1).trim().toLowerCase();
    }

    public String nextPattern() {
        return this.patterns.size() > 0 ? this.patterns.remove(0) : null;
    }
}

