/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.xls.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class ParameterTemplateSchema {
    private HashMap<Integer, String> rowIndexToName = new HashMap();
    private HashMap<String, String> nameToValue = new HashMap();
    private static final Integer maxRowIndex = -1;

    private Integer addToRowIndexToNameMap(Integer rIndex, String name) {
        if (name != null && name.startsWith("$")) {
            name = name.substring(1);
        }
        if (rIndex == null) {
            rIndex = this.getIndexByName(name);
            if (rIndex == null) {
                rIndex = maxRowIndex;
            }
        } else if (!this.rowIndexToName.containsKey(rIndex)) {
            this.rowIndexToName.put(rIndex, name);
        } else {
            String conflictedName = this.rowIndexToName.get(rIndex);
            if (conflictedName == null) {
                this.rowIndexToName.put(rIndex, name);
            } else if (!conflictedName.equalsIgnoreCase(name)) {
                rIndex = maxRowIndex;
            }
        }
        if (rIndex == maxRowIndex || rIndex.equals(maxRowIndex)) {
            Integer max = this.rowIndexToName.size() > 0 ? Collections.max(this.rowIndexToName.keySet()) : 0;
            rIndex = max + 1;
            this.rowIndexToName.put(rIndex, name);
        }
        return rIndex;
    }

    private Integer getIndexByName(String name) {
        Integer res = null;
        if (name != null) {
            for (Integer n : this.rowIndexToName.keySet()) {
                if (!name.equalsIgnoreCase(this.rowIndexToName.get(n))) continue;
                res = n;
            }
        }
        return res;
    }

    private void addToNameToValueMap(String name, String value) {
        if (name != null) {
            if (name.startsWith("$")) {
                name = name.substring(1);
            }
            if (value == null) {
                value = "";
            }
            this.nameToValue.put(name.toLowerCase(), value);
        }
    }

    public void addParameter(Integer rIndex, String name, String value) {
        this.addToRowIndexToNameMap(rIndex, name);
        this.addToNameToValueMap(name, value);
    }

    public Collection<String> getParameterNameSet() {
        return this.rowIndexToName.values();
    }

    public Integer getParameterIndex(String name) {
        if (name != null) {
            for (Integer key : this.rowIndexToName.keySet()) {
                if (!this.rowIndexToName.get(key).equalsIgnoreCase(name)) continue;
                return key;
            }
        }
        return -1;
    }

    public String getValueByName(String name) {
        return String.valueOf(this.nameToValue.get(name.toLowerCase()));
    }
}

