/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.frc.xls.writer;

import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import ru.infor.xls.utils.SheetUtils;

public class WriterUtils {
    public static void writeRow(HSSFSheet sheet, int rowIndex, HSSFRow row, HashMap<String, String> parameter, HashMap<String, String> valuesMap) {
        int lastColumnIndex = WriterUtils.getPatternColumnIndex(row);
        if (sheet != null && row != null && row.getFirstCellNum() >= 0 && lastColumnIndex >= 0) {
            HSSFRow row2 = SheetUtils.getRow(sheet, rowIndex, true);
            row2.setHeight(row.getHeight());
            for (int i = row.getFirstCellNum(); i < lastColumnIndex; ++i) {
                HSSFCell sourCell = SheetUtils.getCell(row, i, false);
                HSSFCell destCell = SheetUtils.getCell(sheet, rowIndex, i, true);
                WriterUtils.copyCell(sourCell, destCell, parameter, valuesMap);
            }
            HSSFSheet sourceSheet = row.getSheet();
            for (int i = 0; i < sourceSheet.getNumMergedRegions(); ++i) {
                CellRangeAddress mergedRegion = sourceSheet.getMergedRegion(i);
                if (mergedRegion.getFirstRow() != row.getRowNum()) continue;
                int rowC = mergedRegion.getLastRow() - mergedRegion.getFirstRow();
                sheet.addMergedRegion(new CellRangeAddress(row2.getRowNum(), row2.getRowNum() + rowC, mergedRegion.getFirstColumn(), mergedRegion.getLastColumn()));
            }
        }
    }

    private static HSSFCell copyCell(HSSFCell sourCell, HSSFCell destCell, HashMap<String, String> parameter, HashMap<String, String> valuesMap) {
        if (sourCell != null && destCell != null) {
            destCell.setCellStyle(sourCell.getCellStyle());
            destCell.setCellType(sourCell.getCellType());
            WriterUtils.resolveCellValue(sourCell, destCell, parameter, valuesMap);
        }
        return destCell;
    }

    private static void resolveCellValue(HSSFCell sourCell, HSSFCell destCell, HashMap<String, String> parameter, HashMap<String, String> valuesMap) {
        if (sourCell != null && destCell != null && sourCell.getCellType() == destCell.getCellType()) {
            switch (sourCell.getCellType()) {
                case 4: {
                    destCell.setCellValue(sourCell.getBooleanCellValue());
                    break;
                }
                case 0: {
                    destCell.setCellValue(sourCell.getNumericCellValue());
                    break;
                }
                case 2: {
                    destCell.setCellFormula(sourCell.getCellFormula());
                    break;
                }
                case 1: {
                    HSSFRichTextString value = sourCell.getRichStringCellValue();
                    String str = value.getString();
                    String str1 = WriterUtils.resolveValue(str, parameter, valuesMap);
                    if (!str.equalsIgnoreCase(str1)) {
                        value = new HSSFRichTextString(str1);
                    }
                    destCell.setCellValue((RichTextString)value);
                    break;
                }
            }
        }
    }

    private static String resolveValue(String str, HashMap<String, String> parameter, HashMap<String, String> valuesMap) {
        String res = str;
        if (str != null) {
            if (parameter != null && str.startsWith("$")) {
                str = str.substring(1).trim();
                for (String key : parameter.keySet()) {
                    if (!key.equalsIgnoreCase(str)) continue;
                    res = parameter.get(key);
                    break;
                }
            }
            if (valuesMap != null && str.startsWith("%")) {
                res = null;
                for (String key : valuesMap.keySet()) {
                    if (!key.equalsIgnoreCase(str)) continue;
                    res = valuesMap.get(key);
                    break;
                }
                if (res == null) {
                    str = str.substring(1).trim();
                    for (String key : valuesMap.keySet()) {
                        if (!key.equalsIgnoreCase(str)) continue;
                        res = valuesMap.get(key);
                        break;
                    }
                }
            }
        }
        return res;
    }

    private static int getPatternColumnIndex(HSSFRow row) {
        short res = -1;
        if (row.getFirstCellNum() >= 0 && row.getLastCellNum() >= 0) {
            for (short i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                String value = SheetUtils.getCellStringValue(SheetUtils.getCell(row, i, false));
                if (value == null || !value.startsWith("#")) continue;
                res = i;
                break;
            }
        }
        if (res < 0) {
            res = row.getLastCellNum();
        }
        return res;
    }
}

