/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.xls;

import java.io.File;
import java.text.SimpleDateFormat;
import javax.swing.table.TableModel;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ru.infor.xls.utils.FormatingUtils;
import ru.infor.xls.utils.SheetUtils;
import ru.infor.xls.utils.WorkbookUtils;

public class XLSSimpleWriter {
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat();

    public static File write(TableModel model, String fileName, String sheetName) {
        File res = null;
        HSSFWorkbook workbook = WorkbookUtils.openWorkbook(fileName, true);
        if (workbook != null) {
            HSSFSheet sheet = WorkbookUtils.recreateSheet(workbook, sheetName);
            XLSSimpleWriter.write(model, sheet);
        }
        res = WorkbookUtils.save(workbook, fileName);
        return res;
    }

    public static HSSFSheet write(TableModel model, HSSFSheet sheet) {
        if (sheet != null) {
            int firstRow = 0;
            int firstColumn = 0;
            for (int i = 0; i < model.getColumnCount(); ++i) {
                SheetUtils.getCell(sheet, firstRow, firstColumn + i, true).setCellValue(model.getColumnName(i));
            }
            ++firstRow;
            for (int r = 0; r < model.getRowCount(); ++r) {
                for (int c = 0; c < model.getColumnCount(); ++c) {
                    SheetUtils.getCell(sheet, firstRow + r, firstColumn + c, true).setCellValue(String.valueOf(model.getValueAt(r, c)));
                }
                FormatingUtils.format(SheetUtils.getRow(sheet, firstRow + r, false), (short)1);
            }
            FormatingUtils.format(SheetUtils.getRow(sheet, 0, false), (short)2);
        }
        return sheet;
    }
}

