/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.xls.utils;

import java.text.DecimalFormat;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class SheetUtils {
    private static final DecimalFormat decimalFormat = new DecimalFormat("# ##0.####");

    public static HSSFCell getCell(HSSFSheet sheet, int rowIndex, int columnIndex, boolean create) {
        HSSFCell cell = null;
        HSSFRow row = SheetUtils.getRow(sheet, rowIndex, create);
        if (row != null) {
            cell = SheetUtils.getCell(row, columnIndex, create);
        }
        return cell;
    }

    public static HSSFRow getRow(HSSFSheet sheet, int rowIndex, boolean create) {
        HSSFRow row = null;
        if (sheet != null && rowIndex >= 0 && (row = sheet.getRow(rowIndex)) == null && create) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    public static HSSFCell getCell(HSSFRow row, int columnIndex, boolean create) {
        HSSFCell cell = null;
        if (row != null && columnIndex >= 0 && (cell = row.getCell(columnIndex)) == null && create) {
            cell = row.createCell(columnIndex);
        }
        return cell;
    }

    public static String getCellStringValue(HSSFCell cell) {
        String res = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case 4: {
                    res = Boolean.toString(cell.getBooleanCellValue());
                    break;
                }
                case 2: {
                    res = cell.getCellFormula();
                    break;
                }
                case 0: {
                    res = decimalFormat.format(cell.getNumericCellValue()).trim();
                    break;
                }
                case 1: {
                    res = cell.getStringCellValue();
                    break;
                }
            }
        }
        return res;
    }

    public static int getPatternColumnIndex(HSSFSheet sheet) {
        int res = -1;
        if (sheet != null) {
            for (int i = sheet.getFirstRowNum(); i < sheet.getLastRowNum(); ++i) {
                HSSFRow row = SheetUtils.getRow(sheet, i, false);
                if (row == null) continue;
                for (int j = row.getFirstCellNum(); j < row.getLastCellNum(); ++j) {
                    HSSFCell cell = SheetUtils.getCell(row, j, false);
                    String value = SheetUtils.getCellStringValue(cell);
                    if (value == null || !value.startsWith("#") || j <= res) continue;
                    res = j;
                }
            }
        }
        return res;
    }
}

