/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.xls.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class WorkbookUtils {
    private static final Logger logger = Logger.getLogger(WorkbookUtils.class);

    public static HSSFWorkbook openWorkbook(String fileName, boolean create) {
        if (fileName != null) {
            try {
                File bookFile = new File(fileName);
                HSSFWorkbook res = WorkbookUtils.openWorkbook1(bookFile);
                if (res == null && create) {
                    if (bookFile.getParentFile() != null && !bookFile.getParent().isEmpty() && !bookFile.getParentFile().exists()) {
                        bookFile.getParentFile().mkdirs();
                    }
                    bookFile.createNewFile();
                    res = new HSSFWorkbook();
                    WorkbookUtils.save(res, fileName);
                }
                return res;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private static HSSFWorkbook openWorkbook1(File bookFile) {
        if (bookFile != null && bookFile.exists()) {
            try {
                HSSFWorkbook res = new HSSFWorkbook((InputStream)new FileInputStream(bookFile));
                return res;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static File save(HSSFWorkbook workbook, String fileName) {
        if (workbook != null && fileName != null) {
            File res;
            block5: {
                res = new File(fileName);
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(res);
                    workbook.write((OutputStream)outputStream);
                    ((OutputStream)outputStream).close();
                    outputStream = null;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    res = null;
                    if (outputStream == null) break block5;
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (Exception e1) {
                        logger.error((Object)e.getMessage(), (Throwable)e1);
                    }
                    outputStream = null;
                }
            }
            return res;
        }
        return null;
    }

    public static HSSFSheet getSheet(HSSFWorkbook workbook, String sheetName, boolean create) {
        HSSFSheet sheet = null;
        if (workbook != null && sheetName != null && (sheet = workbook.getSheet(sheetName)) == null && create) {
            sheet = workbook.createSheet(sheetName);
        }
        return sheet;
    }

    public static HSSFSheet recreateSheet(HSSFWorkbook workbook, String sheetName) {
        HSSFSheet res = null;
        if (workbook != null && sheetName != null) {
            int sheetIndex = workbook.getSheetIndex(sheetName);
            if (sheetIndex > -1) {
                workbook.removeSheetAt(sheetIndex);
            }
            res = workbook.createSheet(sheetName);
        }
        return res;
    }

    public static HSSFWorkbook showOnly(HSSFWorkbook workbook, String sheetName) {
        if (workbook != null && sheetName != null) {
            int i;
            for (i = 0; i < workbook.getNumberOfSheets(); ++i) {
                workbook.setSheetHidden(i, true);
            }
            i = workbook.getSheetIndex(sheetName);
            if (i >= 0) {
                workbook.setSheetHidden(i, false);
            }
        }
        return workbook;
    }
}

