/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import echopointng.BorderEx;
import echopointng.ExtentEx;
import echopointng.MutableStyleEx;
import echopointng.model.CalendarEvent;
import echopointng.model.CalendarSelectionListener;
import echopointng.model.CalendarSelectionModel;
import echopointng.model.DefaultCalendarSelectionModel;
import echopointng.util.ColorKit;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Style;

public class DateChooser
extends AbleComponent {
    public static final Style BLACK_AND_WHITE_STYLE;
    public static final Style COLORFUL_STYLE;
    public static final ImageReference DEFAULT_NAVIGATION_BACKWARD_IMAGE;
    public static final ImageReference DEFAULT_NAVIGATION_FORWARD_IMAGE;
    public static final Style DEFAULT_STYLE;
    public static final String PROPERTY_CALENDAR_BACKGROUND = "calendarBackground";
    public static final String PROPERTY_CALENDAR_BORDER = "calendarBorder";
    public static final String PROPERTY_CALENDAR_FONT = "calendarFont";
    public static final String PROPERTY_WEEK_NUMBER_FOREGROUND = "weekNumberForeground";
    public static final String PROPERTY_CALENDAR_FOREGROUND = "calendarForeground";
    public static final String PROPERTY_CALENDAR_NON_MONTH_FOREGROUND = "calendarNonMonthForeground";
    public static final String PROPERTY_CALENDAR_ROLLOVER_BACKGROUND = "calendarRolloverBackground";
    public static final String PROPERTY_CALENDAR_ROLLOVER_BORDER = "calendarRolloverBorder";
    public static final String PROPERTY_CALENDAR_ROLLOVER_FOREGROUND = "calendarRolloverForeground";
    public static final String PROPERTY_CALENDAR_SELECTED_BACKGROUND = "calendarSelectedBackground";
    public static final String PROPERTY_CALENDAR_SELECTED_BORDER = "calendarSelectedBorder";
    public static final String PROPERTY_CALENDAR_SELECTED_FONT = "calendarSelectedFont";
    public static final String PROPERTY_CALENDAR_SELECTED_FOREGROUND = "calendarSelectedForeground";
    public static final String PROPERTY_DOW_NAME_LENGTH = "dowNameLength";
    public static final String PROPERTY_FAST_MODE = "fastMode";
    public static final String PROPERTY_FIRST_DAY_OF_WEEK = "firstDayOfWeek";
    public static final String PROPERTY_MAXIMUM_DATE = "maximumDate";
    public static final String PROPERTY_MINIMUM_DATE = "minimumDate";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_MONTH_NAME_LENGTH = "monthNameLength";
    public static final String PROPERTY_MONTH_SELECTABLE = "monthSelectable";
    public static final String PROPERTY_NAVIGATION_ARROWS_VISIBLE = "navigationArrowsVisible";
    public static final String PROPERTY_NAVIGATION_BACKGROUND = "navigationBackground";
    public static final String PROPERTY_NAVIGATION_BACKWARD_IMAGE = "navigationBackwardImage";
    public static final String PROPERTY_NAVIGATION_FONT = "navigationFont";
    public static final String PROPERTY_NAVIGATION_FOREGROUND = "navigationForeground";
    public static final String PROPERTY_NAVIGATION_FORWARD_IMAGE = "navigationForwardImage";
    public static final String PROPERTY_NAVIGATION_INHIBITED = "navigationInhibited";
    public static final String PROPERTY_SELECTED_BACKGROUND = "selectedBackground";
    public static final String PROPERTY_SELECTED_BORDER = "selectedBorder";
    public static final String PROPERTY_SELECTED_FONT = "selectedFont";
    public static final String PROPERTY_SELECTED_FOREGROUND = "selectedForeground";
    public static final String PROPERTY_SELECTED_ROLLOVER_BACKGROUND = "selectedRolloverBackground";
    public static final String PROPERTY_SELECTED_ROLLOVER_BORDER = "selectedRolloverBorder";
    public static final String PROPERTY_SELECTED_ROLLOVER_FOREGROUND = "selectedRolloverForeground";
    public static final String PROPERTY_SELECTION_DISPLAYBAR_VISIBLE = "selectionDisplayBarVisible";
    public static final String PROPERTY_WEEK_NUMBER_ABBREVIATION = "weekNumberAbbreviation";
    public static final String PROPERTY_YEAR_RANGE = "yearRange";
    public static final String PROPERTY_YEAR_SELECTABLE = "yearSelectable";
    public static final String SEL_YEAR_PREFIX = "year";
    private ModelChangeListener modelChangeForwarder = new ModelChangeListener();

    public static Calendar calendarClearTimePortion(Calendar cal) {
        return DateOnlyCalendar.clearTimePortion(cal);
    }

    public static Calendar calendarCopy(Calendar cal) {
        return DateChooser.calendarCopy(cal, null);
    }

    public static Calendar calendarCopy(Calendar cal, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (cal != null) {
            Calendar newCal = DateOnlyCalendar.getInstance(locale);
            newCal.setTime(cal.getTime());
            newCal.setFirstDayOfWeek(cal.getFirstDayOfWeek());
            return DateChooser.calendarClearTimePortion(newCal);
        }
        return cal;
    }

    public static Calendar calendarCopy(Date date, Locale locale) {
        if (date == null) {
            throw new IllegalArgumentException("The Date must be non null");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Calendar newCal = DateOnlyCalendar.getInstance(locale);
        newCal.setTime(date);
        return DateChooser.calendarClearTimePortion(newCal);
    }

    public DateChooser() {
        this(DateOnlyCalendar.getInstance());
    }

    public DateChooser(Calendar newSelectedDate) {
        this(newSelectedDate, Locale.getDefault());
    }

    public DateChooser(Calendar newSelectedDate, Locale locale) {
        this.setFocusTraversalParticipant(true);
        this.setLocale(locale);
        Calendar cal = DateChooser.calendarCopy(newSelectedDate, locale);
        this.setModel(new DefaultCalendarSelectionModel(cal));
    }

    public Color getCalendarBackground() {
        return (Color)this.getProperty(PROPERTY_CALENDAR_BACKGROUND);
    }

    public Border getCalendarBorder() {
        return (Border)this.getProperty(PROPERTY_CALENDAR_BORDER);
    }

    public Font getCalendarFont() {
        return (Font)this.getProperty(PROPERTY_CALENDAR_FONT);
    }

    public Color getCalendarForeground() {
        return (Color)this.getProperty(PROPERTY_CALENDAR_FOREGROUND);
    }

    public Color getCalendarNonMonthForeground() {
        return (Color)this.getProperty(PROPERTY_CALENDAR_NON_MONTH_FOREGROUND);
    }

    public Color getCalendarRolloverBackground() {
        return (Color)this.getProperty(PROPERTY_CALENDAR_ROLLOVER_BACKGROUND);
    }

    public Border getCalendarRolloverBorder() {
        return (Border)this.getProperty(PROPERTY_CALENDAR_ROLLOVER_BORDER);
    }

    public Color getCalendarRolloverForeground() {
        return (Color)this.getProperty(PROPERTY_CALENDAR_ROLLOVER_FOREGROUND);
    }

    public Color getCalendarSelectedBackground() {
        return (Color)this.getProperty(PROPERTY_CALENDAR_SELECTED_BACKGROUND);
    }

    public Border getCalendarSelectedBorder() {
        return (Border)this.getProperty(PROPERTY_CALENDAR_SELECTED_BORDER);
    }

    public Font getCalendarSelectedFont() {
        return (Font)this.getProperty(PROPERTY_CALENDAR_SELECTED_FONT);
    }

    public Color getCalendarSelectedForeground() {
        return (Color)this.getProperty(PROPERTY_CALENDAR_SELECTED_FOREGROUND);
    }

    public Calendar getDisplayedDate() {
        return DateChooser.calendarCopy(this.getModel().getDisplayedDate(), this.getLocale());
    }

    public boolean isFastMode() {
        return this.getProperty(PROPERTY_FAST_MODE, true);
    }

    public int getFirstDayOfWeek() {
        Calendar dt = this.getDisplayedDate();
        if (dt == null) {
            dt = Calendar.getInstance(this.getLocale());
        }
        int defaultDow = dt.getFirstDayOfWeek();
        return this.getProperty(PROPERTY_FIRST_DAY_OF_WEEK, defaultDow);
    }

    public void setFirstDayOfWeek(int newValue) {
        this.setProperty(PROPERTY_FIRST_DAY_OF_WEEK, newValue);
    }

    public void setFastMode(boolean newValue) {
        this.setProperty(PROPERTY_FAST_MODE, newValue);
    }

    public Calendar getMaximumDate() {
        return DateChooser.calendarCopy((Calendar)this.getProperty(PROPERTY_MAXIMUM_DATE), this.getLocale());
    }

    public Calendar getMinimumDate() {
        return DateChooser.calendarCopy((Calendar)this.getProperty(PROPERTY_MINIMUM_DATE), this.getLocale());
    }

    public int getDowNameLength() {
        return this.getProperty(PROPERTY_DOW_NAME_LENGTH, 3);
    }

    public CalendarSelectionModel getModel() {
        return (CalendarSelectionModel)this.getProperty(PROPERTY_MODEL);
    }

    public int getMonthNameLength() {
        return this.getProperty(PROPERTY_MONTH_NAME_LENGTH, 3);
    }

    public Color getNavigationBackground() {
        return (Color)this.getProperty(PROPERTY_NAVIGATION_BACKGROUND);
    }

    public ImageReference getNavigationBackwardImage() {
        return (ImageReference)this.getProperty(PROPERTY_NAVIGATION_BACKWARD_IMAGE);
    }

    public Font getNavigationFont() {
        return (Font)this.getProperty(PROPERTY_NAVIGATION_FONT);
    }

    public Color getNavigationForeground() {
        return (Color)this.getProperty(PROPERTY_NAVIGATION_FOREGROUND);
    }

    public ImageReference getNavigationForwardImage() {
        return (ImageReference)this.getProperty(PROPERTY_NAVIGATION_FORWARD_IMAGE);
    }

    public boolean getNavigationInhibited() {
        return this.getProperty(PROPERTY_NAVIGATION_INHIBITED, false);
    }

    public Color getSelectedBackground() {
        return (Color)this.getProperty(PROPERTY_SELECTED_BACKGROUND);
    }

    public Border getSelectedBorder() {
        return (Border)this.getProperty(PROPERTY_SELECTED_BORDER);
    }

    public Calendar getSelectedDate() {
        return DateChooser.calendarCopy(this.getModel().getSelectedDate(), this.getLocale());
    }

    public Font getSelectedFont() {
        return (Font)this.getProperty(PROPERTY_SELECTED_FONT);
    }

    public Color getSelectedForeground() {
        return (Color)this.getProperty(PROPERTY_SELECTED_FOREGROUND);
    }

    public Color getSelectedRolloverBackground() {
        return (Color)this.getProperty(PROPERTY_SELECTED_ROLLOVER_BACKGROUND);
    }

    public Border getSelectedRolloverBorder() {
        return (Border)this.getProperty(PROPERTY_SELECTED_ROLLOVER_BORDER);
    }

    public Color getSelectedRolloverForeground() {
        return (Color)this.getProperty(PROPERTY_SELECTED_ROLLOVER_FOREGROUND);
    }

    public String getWeekNumberAbbreviation() {
        return (String)this.getProperty(PROPERTY_WEEK_NUMBER_ABBREVIATION);
    }

    public int getYearRange() {
        return this.getProperty(PROPERTY_YEAR_RANGE, 30);
    }

    public boolean isMonthSelectable() {
        return this.getProperty(PROPERTY_MONTH_SELECTABLE, true);
    }

    public boolean isNavigationArrowsVisible() {
        return this.getProperty(PROPERTY_NAVIGATION_ARROWS_VISIBLE, true);
    }

    public boolean isSelectionDisplayBarVisible() {
        return this.getProperty(PROPERTY_SELECTION_DISPLAYBAR_VISIBLE, true);
    }

    public boolean isYearSelectable() {
        return this.getProperty(PROPERTY_YEAR_SELECTABLE, false);
    }

    public void processInput(String inputName, Object inputValue) {
        Locale locale = this.getLocale() == null ? Locale.getDefault() : this.getLocale();
        Calendar displayedDate = DateChooser.calendarCopy(this.getDisplayedDate(), locale);
        if (inputName.startsWith("month")) {
            int index = Integer.parseInt((String)inputValue);
            displayedDate.set(2, 0 + index);
            this.setDisplayedDate(displayedDate);
        }
        if (inputName.startsWith(SEL_YEAR_PREFIX)) {
            int year = Integer.parseInt((String)inputValue);
            displayedDate.set(1, year);
            this.setDisplayedDate(displayedDate);
        }
        if (!inputName.equals("fwd") && !inputName.equals("bwd")) {
            if (inputName.equals("sel")) {
                this.setDisplayedDate(this.getSelectedDate());
            } else if (inputName.equals("displayedDate")) {
                Calendar newVal = this.parseYYYYMMD(inputValue);
                this.setDisplayedDate(newVal);
            } else if (inputName.startsWith("click")) {
                Calendar newVal = this.parseYYYYMMD(inputValue);
                this.setSelectedDate(newVal);
            }
        }
    }

    private Calendar parseYYYYMMD(Object inputValue) {
        Date dt;
        Locale locale = this.getLocale() == null ? Locale.getDefault() : this.getLocale();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            dt = sdf.parse((String)inputValue);
        }
        catch (ParseException e) {
            throw new IllegalStateException("This should never happen!");
        }
        Calendar newCal = DateChooser.calendarCopy(dt, locale);
        return newCal;
    }

    public void setCalendarBackground(Color newCalendarBackground) {
        this.setProperty(PROPERTY_CALENDAR_BACKGROUND, newCalendarBackground);
    }

    public void setCalendarBorder(Border newValue) {
        this.setProperty(PROPERTY_CALENDAR_BORDER, newValue);
    }

    public void setCalendarFont(Font newCalendarFont) {
        this.setProperty(PROPERTY_CALENDAR_FONT, newCalendarFont);
    }

    public void setCalendarForeground(Color newCalendarForeground) {
        this.setProperty(PROPERTY_CALENDAR_FOREGROUND, newCalendarForeground);
    }

    public void setCalendarNonMonthForeground(Color newCalendarNonMonthForeground) {
        this.setProperty(PROPERTY_CALENDAR_NON_MONTH_FOREGROUND, newCalendarNonMonthForeground);
    }

    public void setCalendarRolloverBackground(Color newCalendarRolloverBackground) {
        this.setProperty(PROPERTY_CALENDAR_ROLLOVER_BACKGROUND, newCalendarRolloverBackground);
    }

    public void setCalendarRolloverBorder(Border newValue) {
        this.setProperty(PROPERTY_CALENDAR_ROLLOVER_BORDER, newValue);
    }

    public void setCalendarRolloverForeground(Color newCalendarRolloverForeground) {
        this.setProperty(PROPERTY_CALENDAR_ROLLOVER_FOREGROUND, newCalendarRolloverForeground);
    }

    public void setCalendarSelectedBackground(Color newCalendarBackground) {
        this.setProperty(PROPERTY_CALENDAR_SELECTED_BACKGROUND, newCalendarBackground);
    }

    public void setCalendarSelectedBorder(Border newValue) {
        this.setProperty(PROPERTY_CALENDAR_SELECTED_BORDER, newValue);
    }

    public void setCalendarSelectedFont(Font newFont) {
        this.setProperty(PROPERTY_CALENDAR_SELECTED_FONT, newFont);
    }

    public void setCalendarSelectedForeground(Color newCalendarForeground) {
        this.setProperty(PROPERTY_CALENDAR_SELECTED_FOREGROUND, newCalendarForeground);
    }

    public void setDisplayedDate(Calendar newDisplayedDate) {
        this.getModel().setDisplayedDate(newDisplayedDate);
    }

    public void setMaximumDate(Calendar newValue) {
        this.setProperty(PROPERTY_MAXIMUM_DATE, DateChooser.calendarCopy(newValue, this.getLocale()));
    }

    public void setMinimumDate(Calendar newValue) {
        this.setProperty(PROPERTY_MINIMUM_DATE, DateChooser.calendarCopy(newValue, this.getLocale()));
    }

    public void setDowNameLength(int newValue) {
        this.setProperty(PROPERTY_DOW_NAME_LENGTH, newValue);
    }

    public void setModel(CalendarSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException("The CalendarSelectionModel mus be non null!");
        }
        CalendarSelectionModel oldModel = this.getModel();
        if (oldModel != newModel) {
            if (oldModel != null) {
                oldModel.removeListener(this.modelChangeForwarder);
            }
            newModel.addListener(this.modelChangeForwarder);
        }
        this.setProperty(PROPERTY_MODEL, newModel);
    }

    public void setMonthNameLength(int newValue) {
        this.setProperty(PROPERTY_MONTH_NAME_LENGTH, newValue);
    }

    public void setMonthSelectable(boolean newMonthSelectable) {
        this.setProperty(PROPERTY_MONTH_SELECTABLE, newMonthSelectable);
    }

    public void setNavigationArrowsVisible(boolean newValue) {
        this.setProperty(PROPERTY_NAVIGATION_ARROWS_VISIBLE, newValue);
    }

    public void setNavigationBackground(Color newNavigationBackground) {
        this.setProperty(PROPERTY_NAVIGATION_BACKGROUND, newNavigationBackground);
    }

    public void setNavigationBackwardImage(ImageReference newImage) {
        this.setProperty(PROPERTY_NAVIGATION_BACKWARD_IMAGE, newImage);
    }

    public void setNavigationFont(Font newNavigationFont) {
        this.setProperty(PROPERTY_NAVIGATION_FONT, newNavigationFont);
    }

    public void setNavigationForeground(Color newNavigationForeground) {
        this.setProperty(PROPERTY_NAVIGATION_FOREGROUND, newNavigationForeground);
    }

    public void setNavigationForwardImage(ImageReference newImage) {
        this.setProperty(PROPERTY_NAVIGATION_FORWARD_IMAGE, newImage);
    }

    public void setNavigationInhibited(boolean newValue) {
        this.setProperty(PROPERTY_NAVIGATION_INHIBITED, newValue);
    }

    public void setSelectedBackground(Color newSelectedBackground) {
        this.setProperty(PROPERTY_SELECTED_BACKGROUND, newSelectedBackground);
    }

    public void setSelectedBorder(Border newValue) {
        this.setProperty(PROPERTY_SELECTED_BORDER, newValue);
    }

    public void setSelectedDate(Calendar newSelectedDate) {
        this.getModel().setSelectedDate(newSelectedDate);
    }

    public void setSelectedFont(Font newSelectedFont) {
        this.setProperty(PROPERTY_SELECTED_FONT, newSelectedFont);
    }

    public void setSelectedForeground(Color newSelectedForeground) {
        this.setProperty(PROPERTY_SELECTED_FOREGROUND, newSelectedForeground);
    }

    public void setSelectedRolloverBackground(Color newSelectedRolloverBackground) {
        this.setProperty(PROPERTY_SELECTED_ROLLOVER_BACKGROUND, newSelectedRolloverBackground);
    }

    public void setSelectedRolloverBorder(Border newValue) {
        this.setProperty(PROPERTY_SELECTED_ROLLOVER_BORDER, newValue);
    }

    public void setSelectedRolloverForeground(Color newSelectedRolloverForeground) {
        this.setProperty(PROPERTY_SELECTED_ROLLOVER_FOREGROUND, newSelectedRolloverForeground);
    }

    public void setSelectionDisplayBarVisible(boolean newValue) {
        this.setProperty(PROPERTY_SELECTION_DISPLAYBAR_VISIBLE, newValue);
    }

    public void setWeekNumberAbbreviation(String abbreviation) {
        this.setProperty(PROPERTY_WEEK_NUMBER_ABBREVIATION, abbreviation);
    }

    public void setYearRange(int newYearRange) {
        this.setProperty(PROPERTY_YEAR_RANGE, newYearRange);
    }

    public void setYearSelectable(boolean newYearSelectable) {
        this.setProperty(PROPERTY_YEAR_SELECTABLE, newYearSelectable);
    }

    public Color getWeekNumberForeground() {
        return (Color)this.getProperty(PROPERTY_WEEK_NUMBER_FOREGROUND);
    }

    public void setWeekNumberForeground(Color newValue) {
        this.setProperty(PROPERTY_WEEK_NUMBER_FOREGROUND, newValue);
    }

    static {
        DEFAULT_NAVIGATION_BACKWARD_IMAGE = new ResourceImageReference("/echopointng/resource/images/smallleftarrow.gif", new Extent(12), new Extent(11));
        DEFAULT_NAVIGATION_FORWARD_IMAGE = new ResourceImageReference("/echopointng/resource/images/smallrightarrow.gif", new Extent(12), new Extent(11));
        Color GUNMETAL_BLUEISH_WHITE = ColorKit.makeColor("#ACBCDC");
        BorderEx DEFAULT_BORDER = new BorderEx(1, Color.WHITE);
        BorderEx DEFAULT_ROLLOVER_BORDER = new BorderEx(1, GUNMETAL_BLUEISH_WHITE);
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty(PROPERTY_FAST_MODE, true);
        style.setProperty("font", new Font(Font.ARIAL, 0, (Extent)new ExtentEx("8pt")));
        style.setProperty(PROPERTY_WEEK_NUMBER_FOREGROUND, ColorKit.clr("#9400D3"));
        style.setProperty("mouseCursor", 3);
        style.setProperty(PROPERTY_CALENDAR_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_CALENDAR_FOREGROUND, Color.BLACK);
        style.setProperty(PROPERTY_CALENDAR_BORDER, (Object)DEFAULT_BORDER);
        style.setProperty(PROPERTY_CALENDAR_SELECTED_FOREGROUND, Color.ORANGE);
        style.setProperty(PROPERTY_CALENDAR_SELECTED_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_CALENDAR_SELECTED_BORDER, (Object)DEFAULT_ROLLOVER_BORDER);
        style.setProperty(PROPERTY_CALENDAR_NON_MONTH_FOREGROUND, Color.LIGHTGRAY);
        style.setProperty(PROPERTY_CALENDAR_ROLLOVER_FOREGROUND, Color.ORANGE);
        style.setProperty(PROPERTY_CALENDAR_ROLLOVER_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_CALENDAR_ROLLOVER_BORDER, (Object)DEFAULT_ROLLOVER_BORDER);
        style.setProperty(PROPERTY_NAVIGATION_FOREGROUND, Color.WHITE);
        style.setProperty(PROPERTY_NAVIGATION_BACKGROUND, GUNMETAL_BLUEISH_WHITE);
        style.setProperty(PROPERTY_SELECTED_FOREGROUND, Color.WHITE);
        style.setProperty(PROPERTY_SELECTED_BACKGROUND, GUNMETAL_BLUEISH_WHITE);
        style.setProperty(PROPERTY_SELECTED_BORDER, (Object)DEFAULT_BORDER);
        style.setProperty(PROPERTY_SELECTED_ROLLOVER_FOREGROUND, Color.ORANGE);
        style.setProperty(PROPERTY_SELECTED_ROLLOVER_FOREGROUND, Color.ORANGE);
        style.setProperty(PROPERTY_SELECTED_ROLLOVER_BACKGROUND, GUNMETAL_BLUEISH_WHITE);
        style.setProperty(PROPERTY_SELECTED_ROLLOVER_BORDER, (Object)DEFAULT_ROLLOVER_BORDER);
        style.setProperty(PROPERTY_NAVIGATION_BACKWARD_IMAGE, DEFAULT_NAVIGATION_BACKWARD_IMAGE);
        style.setProperty(PROPERTY_NAVIGATION_FORWARD_IMAGE, DEFAULT_NAVIGATION_FORWARD_IMAGE);
        DEFAULT_STYLE = style;
        style = new MutableStyleEx();
        style.setProperty("font", new Font(Font.ARIAL, 0, (Extent)new ExtentEx("8pt")));
        style.setProperty("mouseCursor", 3);
        style.setProperty(PROPERTY_CALENDAR_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_CALENDAR_FOREGROUND, Color.BLACK);
        style.setProperty(PROPERTY_SELECTED_FOREGROUND, Color.RED);
        style.setProperty(PROPERTY_SELECTED_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_CALENDAR_NON_MONTH_FOREGROUND, Color.LIGHTGRAY);
        style.setProperty(PROPERTY_CALENDAR_ROLLOVER_FOREGROUND, Color.ORANGE);
        style.setProperty(PROPERTY_CALENDAR_ROLLOVER_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_NAVIGATION_FOREGROUND, Color.WHITE);
        style.setProperty(PROPERTY_NAVIGATION_BACKGROUND, Color.BLUE);
        style.setProperty(PROPERTY_SELECTED_FOREGROUND, Color.RED);
        style.setProperty(PROPERTY_SELECTED_ROLLOVER_FOREGROUND, Color.ORANGE);
        style.setProperty(PROPERTY_SELECTED_ROLLOVER_BACKGROUND, new Color(255, 255, 204));
        style.setProperty(PROPERTY_SELECTED_BACKGROUND, new Color(255, 255, 204));
        style.setProperty(PROPERTY_NAVIGATION_BACKWARD_IMAGE, DEFAULT_NAVIGATION_BACKWARD_IMAGE);
        style.setProperty(PROPERTY_NAVIGATION_FORWARD_IMAGE, DEFAULT_NAVIGATION_FORWARD_IMAGE);
        COLORFUL_STYLE = style;
        style = new MutableStyleEx();
        style.setProperty("font", new Font(Font.ARIAL, 0, (Extent)new ExtentEx("8pt")));
        style.setProperty("mouseCursor", 3);
        style.setProperty(PROPERTY_CALENDAR_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_CALENDAR_FOREGROUND, Color.BLACK);
        style.setProperty(PROPERTY_SELECTED_FOREGROUND, Color.BLACK);
        style.setProperty(PROPERTY_SELECTED_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_CALENDAR_NON_MONTH_FOREGROUND, Color.LIGHTGRAY);
        style.setProperty(PROPERTY_CALENDAR_ROLLOVER_FOREGROUND, Color.DARKGRAY);
        style.setProperty(PROPERTY_CALENDAR_ROLLOVER_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_NAVIGATION_FOREGROUND, Color.WHITE);
        style.setProperty(PROPERTY_NAVIGATION_BACKGROUND, Color.BLACK);
        style.setProperty(PROPERTY_SELECTED_FOREGROUND, Color.BLACK);
        style.setProperty(PROPERTY_SELECTED_ROLLOVER_FOREGROUND, Color.DARKGRAY);
        style.setProperty(PROPERTY_SELECTED_ROLLOVER_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_SELECTED_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_NAVIGATION_BACKWARD_IMAGE, DEFAULT_NAVIGATION_BACKWARD_IMAGE);
        style.setProperty(PROPERTY_NAVIGATION_FORWARD_IMAGE, DEFAULT_NAVIGATION_FORWARD_IMAGE);
        BLACK_AND_WHITE_STYLE = style;
    }

    private static class DateOnlyCalendar
    extends GregorianCalendar {
        public static Calendar getInstance(Locale locale) {
            return new DateOnlyCalendar(locale);
        }

        public DateOnlyCalendar(Locale locale) {
            Calendar now = Calendar.getInstance(locale);
            this.setTime(now.getTime());
            DateOnlyCalendar.clearTimePortion(now);
        }

        public String toString() {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy E");
            return sdf.format(this.getTime());
        }

        public static Calendar clearTimePortion(Calendar cal) {
            if (cal != null) {
                cal.clear(10);
                cal.clear(12);
                cal.clear(13);
                cal.clear(14);
            }
            return cal;
        }
    }

    private class ModelChangeListener
    implements CalendarSelectionListener,
    Serializable {
        private ModelChangeListener() {
        }

        public void displayedDateChange(CalendarEvent calEvent) {
            DateChooser.this.firePropertyChange("displayedDate", null, calEvent.getCalendar());
        }

        public void selectedDateChange(CalendarEvent calEvent) {
            DateChooser.this.firePropertyChange("selectedDate", null, calEvent.getCalendar());
        }
    }
}

