/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import echopointng.BorderEx;
import echopointng.MutableStyleEx;
import echopointng.TitleBar;
import echopointng.able.Expandable;
import echopointng.model.DefaultExpansionModel;
import echopointng.model.ExpansionGroup;
import echopointng.model.ExpansionModel;
import echopointng.util.ColorKit;
import java.io.Serializable;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;

public class ExpandableSection
extends AbleComponent
implements Expandable {
    public static final String PROPERTY_TITLEBAR = "titleBar";
    private ChangeListener internalExpansionListener = new InternalExpansionModelListener();
    public static final Style DEFAULT_STYLE;

    public ExpandableSection() {
        this((String)null);
    }

    public ExpandableSection(String title) {
        this(new TitleBar(title));
    }

    public ExpandableSection(TitleBar title) {
        this.setTitleBar(title);
        this.setExpansionModel(new DefaultExpansionModel(false));
    }

    public TitleBar getTitleBar() {
        return (TitleBar)this.getProperty(PROPERTY_TITLEBAR);
    }

    public void setTitleBar(TitleBar newValue) {
        TitleBar oldValue = this.getTitleBar();
        if (oldValue != null) {
            this.remove(oldValue);
            if (oldValue.getExpansionModel() != null) {
                oldValue.getExpansionModel().removeChangeListener(this.internalExpansionListener);
            }
        }
        if (newValue != null) {
            this.add(newValue);
            if (newValue.getExpansionModel() != null) {
                newValue.getExpansionModel().addChangeListener(this.internalExpansionListener);
            }
        }
        this.setProperty(PROPERTY_TITLEBAR, newValue);
    }

    public void validate() {
        if (this.getExpansionGroup() != null) {
            this.getExpansionGroup().validate();
        }
        if (this.getTitleBar() != null) {
            this.getTitleBar().setExpanded(this.isExpanded());
        }
    }

    public ExpansionGroup getExpansionGroup() {
        return (ExpansionGroup)this.getProperty("expansionGroup");
    }

    public ExpansionModel getExpansionModel() {
        return (ExpansionModel)this.getProperty("expansionModel");
    }

    public boolean isExpanded() {
        return this.getExpansionModel() == null ? false : this.getExpansionModel().isExpanded();
    }

    public void setExpanded(boolean isExpanded) {
        ExpansionModel model = this.getExpansionModel();
        if (model != null) {
            model.setExpanded(isExpanded);
        }
    }

    public void setExpansionGroup(ExpansionGroup newExpansionGroup) {
        ExpansionGroup oldValue = this.getExpansionGroup();
        if (oldValue != null) {
            oldValue.removeExpandable(this);
        }
        if (newExpansionGroup != null) {
            newExpansionGroup.addExpandable(this);
        }
        this.setProperty("expansionGroup", newExpansionGroup);
    }

    public void setExpansionModel(ExpansionModel newExpansionModel) {
        this.setProperty("expansionModel", newExpansionModel);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTitleBar());
        sb.append(" : ");
        sb.append(super.toString());
        return sb.toString();
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty("border", (Object)new BorderEx(ColorKit.makeColor("#ACBCDC")));
        DEFAULT_STYLE = style;
    }

    private class InternalExpansionModelListener
    implements ChangeListener,
    Serializable {
        private InternalExpansionModelListener() {
        }

        public void stateChanged(ChangeEvent e) {
            ExpansionModel expansionModel = (ExpansionModel)e.getSource();
            if (expansionModel != null) {
                boolean isExpanded = expansionModel.isExpanded();
                if (expansionModel != ExpandableSection.this.getExpansionModel()) {
                    ExpandableSection.this.setExpanded(isExpanded);
                } else if (ExpandableSection.this.getTitleBar() != null && ExpandableSection.this.getTitleBar().getExpansionModel() != null) {
                    ExpandableSection.this.getTitleBar().getExpansionModel().setExpanded(isExpanded);
                }
                Boolean oldValue = !isExpanded;
                Boolean newValue = isExpanded;
                ExpandableSection.this.firePropertyChange("expanded", oldValue, newValue);
            }
        }
    }
}

