/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.ComponentEx;
import echopointng.MutableStyleEx;
import echopointng.able.Attributeable;
import echopointng.able.Borderable;
import echopointng.able.Insetable;
import echopointng.able.MouseCursorable;
import echopointng.able.Sizeable;
import echopointng.richtext.DefaultRichTextRenderer;
import echopointng.richtext.RichTextRenderer;
import echopointng.richtext.RichTextSpellChecker;
import echopointng.util.ColorKit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.text.Document;
import nextapp.echo2.app.text.StringDocument;
import nextapp.echo2.app.text.TextComponent;

public class RichTextArea
extends TextComponent
implements Sizeable,
Insetable,
MouseCursorable,
Borderable,
Attributeable {
    public static final Style DEFAULT_STYLE;
    public static final Color DEFAULT_TOOLBAR_BACKGROUND;
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_EDITOR_BACKGROUND = "editorBackground";
    public static final String PROPERTY_EDITOR_BORDER = "editorBorder";
    public static final String PROPERTY_EDITOR_FONT = "editorFont";
    public static final String PROPERTY_EDITOR_FOREGROUND = "editorForeground";
    public static final String PROPERTY_RENDERER = "renderer";
    public static final String PROPERTY_SPELL_CHECK_IN_PROGRESS = "spellCheckInProgress";
    public static final String PROPERTY_SPELL_CHECKER = "spellChecker";
    public static final String PROPERTY_TOOLBAR_ALIGNMENT = "toolBarAlignment";
    public static final String PROPERTY_TOOLBAR_BACKGROUND = "toolBarBackground";
    private Map attributeMap;

    public RichTextArea() {
        this(null, null, null);
    }

    public RichTextArea(Document document) {
        this(document, null, null, null);
    }

    public RichTextArea(Document document, String text, Extent width, Extent height) {
        super(document);
        this.setFocusTraversalParticipant(true);
        this.setRenderer(new DefaultRichTextRenderer());
        this.setDocument(document);
        if (text != null) {
            this.setText(text);
        }
        this.setWidth(width);
        this.setHeight(height);
        this.setSpellCheckInProgress(false);
    }

    public RichTextArea(Extent width, Extent height) {
        this(null, width, height);
    }

    public RichTextArea(String text) {
        this(text, null, null);
    }

    public RichTextArea(String text, Extent width, Extent height) {
        this((Document)new StringDocument(), text, width, height);
    }

    public Object getAttribute(String attributeName) {
        if (this.attributeMap != null) {
            return this.attributeMap.get(attributeName);
        }
        return null;
    }

    public String[] getAttributeNames() {
        if (this.attributeMap == null) {
            return new String[0];
        }
        int count = 0;
        String[] attributeNames = new String[this.attributeMap.keySet().size()];
        Iterator iter = this.attributeMap.keySet().iterator();
        while (iter.hasNext()) {
            attributeNames[count++] = (String)iter.next();
        }
        return attributeNames;
    }

    public Color getEditorBackground() {
        return (Color)this.getProperty(PROPERTY_EDITOR_BACKGROUND);
    }

    public Border getEditorBorder() {
        return (Border)this.getProperty(PROPERTY_EDITOR_BORDER);
    }

    public Font getEditorFont() {
        return (Font)this.getProperty(PROPERTY_EDITOR_FONT);
    }

    public Color getEditorForeground() {
        return (Color)this.getProperty(PROPERTY_EDITOR_FOREGROUND);
    }

    public int getMouseCursor() {
        return ComponentEx.getProperty((Component)this, "mouseCursor", 0);
    }

    public String getMouseCursorUri() {
        return (String)this.getProperty("mouseCursorUri");
    }

    public Insets getOutsets() {
        return (Insets)this.getProperty("outsets");
    }

    public RichTextRenderer getRenderer() {
        return (RichTextRenderer)this.getProperty(PROPERTY_RENDERER);
    }

    public RichTextSpellChecker getSpellChecker() {
        return (RichTextSpellChecker)this.getProperty(PROPERTY_SPELL_CHECKER);
    }

    public int getToolBarAlignment() {
        return ComponentEx.getProperty((Component)this, PROPERTY_TOOLBAR_ALIGNMENT, 6);
    }

    public Color getToolBarBackground() {
        return (Color)this.getProperty(PROPERTY_TOOLBAR_BACKGROUND);
    }

    public boolean isEditable() {
        return ComponentEx.getProperty((Component)this, PROPERTY_EDITABLE, true);
    }

    public boolean isSpellCheckInProgress() {
        return ComponentEx.getProperty((Component)this, PROPERTY_SPELL_CHECK_IN_PROGRESS, false);
    }

    public void processInput(String inputName, Object inputValue) {
        if ("text".equals(inputName)) {
            inputValue = this.makeValidXHTML(new StringBuffer((String)inputValue));
        }
        super.processInput(inputName, inputValue);
        if ("spellcheck".equals(inputName)) {
            this.setSpellCheckInProgress(!this.isSpellCheckInProgress());
        }
    }

    protected String makeValidXHTML(StringBuffer buffer) {
        String[] tags = new String[]{"<br", "<img", "<col", "<hr", "<input"};
        for (int i = 0; i < tags.length; ++i) {
            String tag = tags[i];
            int index = buffer.indexOf(tag);
            while (index != -1) {
                int endindex = buffer.indexOf(">", index);
                String currentTag = buffer.substring(index, endindex + 1);
                currentTag = currentTag.substring(0, currentTag.length() - 1);
                currentTag = currentTag + "/>";
                buffer.replace(index, endindex + 1, currentTag);
                index = buffer.indexOf(tag, endindex + 1);
            }
        }
        return buffer.toString();
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap();
        }
        this.attributeMap.put(attributeName, attributeValue);
    }

    public void setEditable(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_EDITABLE, newValue);
    }

    public void setEditorBackground(Color editorBackground) {
        this.setProperty(PROPERTY_EDITOR_BACKGROUND, editorBackground);
    }

    public void setEditorBorder(Border editorBorder) {
        this.setProperty(PROPERTY_EDITOR_BORDER, editorBorder);
    }

    public void setEditorFont(Font editorFont) {
        this.setProperty(PROPERTY_EDITOR_FONT, editorFont);
    }

    public void setEditorForeground(Color editorForeground) {
        this.setProperty(PROPERTY_EDITOR_FOREGROUND, editorForeground);
    }

    public void setMouseCursor(int mouseCursor) {
        ComponentEx.setProperty((Component)this, "mouseCursor", mouseCursor);
    }

    public void setMouseCursorUri(String mouseCursorURI) {
        this.setProperty("mouseCursorUri", mouseCursorURI);
    }

    public void setOutsets(Insets newValue) {
        this.setProperty("outsets", newValue);
    }

    public void setRenderer(RichTextRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("The RichTextRenderer must be non null");
        }
        this.setProperty(PROPERTY_RENDERER, renderer);
    }

    public void setSpellChecker(RichTextSpellChecker spellChecker) {
        this.setProperty(PROPERTY_SPELL_CHECKER, spellChecker);
    }

    public void setSpellCheckInProgress(boolean spellCheckInProgress) {
        ComponentEx.setProperty((Component)this, PROPERTY_SPELL_CHECK_IN_PROGRESS, spellCheckInProgress);
    }

    public void setToolBarAlignment(int newValue) {
        if (newValue != 6 && newValue != 7) {
            throw new IllegalArgumentException("The toolbar alignment must be either Alignment.TOP or Alignment.BOTTOM");
        }
        ComponentEx.setProperty((Component)this, PROPERTY_TOOLBAR_ALIGNMENT, newValue);
    }

    public void setToolBarBackground(Color newValue) {
        this.setProperty(PROPERTY_TOOLBAR_BACKGROUND, newValue);
    }

    static {
        DEFAULT_TOOLBAR_BACKGROUND = new Color(0xEFEFEF);
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty("width", new Extent(620));
        style.setProperty("height", new Extent(200));
        style.setProperty("background", ColorKit.makeColor(0xEFEFDE));
        style.setProperty(PROPERTY_EDITOR_BACKGROUND, Color.WHITE);
        style.setProperty(PROPERTY_TOOLBAR_BACKGROUND, ColorKit.makeColor(0xEFEFDE));
        DEFAULT_STYLE = style;
    }
}

