/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import echopointng.BorderEx;
import echopointng.ExtentEx;
import echopointng.MutableStyleEx;
import echopointng.model.BoundedRangeModel;
import echopointng.model.DefaultBoundedRangeModel;
import echopointng.util.ColorKit;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.EventListener;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;

public class Slider
extends AbleComponent {
    public static final Style DEFAULT_HORIZONTAL_STYLE;
    public static final Style DEFAULT_VERTICAL_STYLE;
    public static final Style DEFAULT_STYLE;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_VALUE_DECIMAL_PLACES = "valueRatio";
    public static final String PROPERTY_VALUE_RATIO = "valueRatio";
    public static final String PROPERTY_IMMEDIATE_NOTIFICATION = "immediateNotification";
    public static final String VALUE_CHANGED_PROPERTY = "value";
    protected transient ChangeEvent changeEvent = null;
    protected ChangeListener changeListener = null;

    public Slider() {
        this(new DefaultBoundedRangeModel());
    }

    public Slider(BoundedRangeModel model) {
        this.setModel(model);
    }

    public Slider(Style style) {
        this();
        this.setStyle(style);
    }

    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if (VALUE_CHANGED_PROPERTY.equals(inputName)) {
            this.setValue((Integer)inputValue);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.getEventListenerList().addListener(ChangeListener.class, (EventListener)l);
    }

    protected ChangeListener createChangeListener() {
        return new InternalModelListener();
    }

    protected void fireStateChanged() {
        EventListener[] listeners = this.getEventListenerList().getListeners(ChangeListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent((Object)this);
            }
            ((ChangeListener)listeners[index]).stateChanged(this.changeEvent);
        }
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public BoundedRangeModel getModel() {
        return (BoundedRangeModel)this.getProperty(PROPERTY_MODEL);
    }

    public int getOrientation() {
        return this.getProperty(PROPERTY_ORIENTATION, 0);
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public double getDoubleValue() {
        int value = this.getModel().getValue();
        double d = (double)value * this.getValueRatio();
        int powersOfTen = 10 * this.getValueDecimalPlaces();
        if (powersOfTen != 0) {
            BigDecimal decimal = new BigDecimal(d * (double)powersOfTen);
            BigDecimal powersOfTenDecimal = new BigDecimal((double)powersOfTen);
            BigDecimal result = decimal.divide(powersOfTenDecimal, 5);
            return result.doubleValue();
        }
        return new Double(d).intValue();
    }

    public int getValueDecimalPlaces() {
        return this.getProperty("valueRatio", 0);
    }

    public double getValueRatio() {
        return this.getProperty("valueRatio", 1);
    }

    public void setValueDecimalPlaces(int newValue) {
        this.setProperty("valueRatio", newValue);
    }

    public void setValueRatio(double newValue) {
        this.setProperty("valueRatio", newValue);
    }

    public void removeChangeListener(ChangeListener l) {
        this.getEventListenerList().removeListener(ChangeListener.class, (EventListener)l);
    }

    public void setMaximum(int n) {
        this.getModel().setMaximum(n);
    }

    public void setMinimum(int n) {
        this.getModel().setMinimum(n);
    }

    public void setModel(BoundedRangeModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException("The model must not be null");
        }
        BoundedRangeModel oldModel = this.getModel();
        this.setProperty(PROPERTY_MODEL, newModel);
        if (newModel != oldModel) {
            if (oldModel != null) {
                oldModel.removeChangeListener(this.changeListener);
                this.changeListener = null;
            }
            if (newModel != null) {
                this.changeListener = this.createChangeListener();
                newModel.addChangeListener(this.changeListener);
            }
            newModel.setExtent(0);
        }
    }

    public void setOrientation(int newOrientation) {
        if (newOrientation != 0 && newOrientation != 1) {
            throw new IllegalArgumentException("The orientation must be either ORIENTATION_HORIZONTAL or ORIENTATION_VERTICAL");
        }
        this.setProperty(PROPERTY_ORIENTATION, newOrientation);
    }

    public void setValue(int n) {
        this.getModel().setValue(n);
    }

    public boolean isImmediateNotification() {
        return this.getProperty(PROPERTY_IMMEDIATE_NOTIFICATION, false);
    }

    public void setImmediateNotification(boolean newValue) {
        this.setProperty(PROPERTY_IMMEDIATE_NOTIFICATION, newValue);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("w=");
        sb.append(this.getWidth());
        sb.append(" h=");
        sb.append(this.getHeight());
        sb.append(" orient=");
        sb.append(this.getOrientation() == 0 ? "horz" : "vert");
        sb.append(" val=");
        sb.append(this.getValue());
        sb.append(" dblval=");
        sb.append(this.getDoubleValue());
        return sb.toString();
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty(PROPERTY_ORIENTATION, 0);
        style.setProperty("height", (Object)new ExtentEx("5px"));
        style.setProperty("width", (Object)new ExtentEx("100px"));
        BorderEx railBorder = new BorderEx(1, ColorKit.clr("#9d9c99"), 1, 1, ColorKit.clr("#eeefff"), 1, 1, ColorKit.clr("#9d9c99"), 1, 1, ColorKit.clr("#eeefff"), 1);
        style.setProperty("border", (Object)railBorder);
        style.setProperty("background", ColorKit.clr("#f0ede0"));
        DEFAULT_STYLE = DEFAULT_HORIZONTAL_STYLE = style;
        style = new MutableStyleEx(DEFAULT_HORIZONTAL_STYLE);
        style.setProperty(PROPERTY_ORIENTATION, 1);
        style.setProperty("width", (Object)new ExtentEx("5px"));
        style.setProperty("height", (Object)new ExtentEx("100px"));
        DEFAULT_VERTICAL_STYLE = style;
    }

    private class InternalModelListener
    implements ChangeListener,
    Serializable {
        private InternalModelListener() {
        }

        public void stateChanged(ChangeEvent e) {
            Integer newValue = new Integer(Slider.this.getValue());
            Slider.this.firePropertyChange(Slider.VALUE_CHANGED_PROPERTY, null, newValue);
            Slider.this.fireStateChanged();
        }
    }
}

