/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.MutableStyleEx;
import echopointng.TableEx;
import echopointng.Tree;
import echopointng.tree.DefaultTreeCellRenderer;
import echopointng.tree.DefaultTreeSelectionModel;
import echopointng.tree.TreeCellRenderer;
import echopointng.tree.TreeExpansionEvent;
import echopointng.tree.TreeExpansionListener;
import echopointng.tree.TreeModelEvent;
import echopointng.tree.TreeModelListener;
import echopointng.tree.TreePath;
import echopointng.tree.TreeSelectionModel;
import echopointng.treetable.AbstractTreeTableModel;
import echopointng.treetable.DefaultTreeTableModel;
import echopointng.treetable.TreeTableModel;
import java.util.Enumeration;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;
import nextapp.echo2.app.list.DefaultListSelectionModel;
import nextapp.echo2.app.list.ListSelectionModel;
import nextapp.echo2.app.table.AbstractTableModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableModel;

public class TreeTable
extends TableEx {
    private TreeAndTableCellRenderer treeAndTableCellRenderer = null;

    public TreeTable() {
        this(new DefaultTreeTableModel());
    }

    public TreeTable(TreeTableModel treeModel) {
        this(treeModel, new TreeAndTableCellRenderer(treeModel));
    }

    private TreeTable(TreeTableModel treeModel, TreeAndTableCellRenderer renderer) {
        super((TableModel)new TreeTableModelAdapter(treeModel, renderer));
        if (treeModel != renderer.getModel()) {
            throw new IllegalArgumentException("Mismatched TreeTableModel");
        }
        this.init(renderer);
    }

    public void collapseAll() {
        this.treeAndTableCellRenderer.collapseAll();
    }

    public void collapsePath(TreePath path) {
        this.treeAndTableCellRenderer.collapsePath(path);
    }

    public void collapseRow(int row) {
        this.treeAndTableCellRenderer.collapseRow(row);
    }

    public void expandAll() {
        this.treeAndTableCellRenderer.expandAll();
    }

    public void expandPath(TreePath path) {
        this.treeAndTableCellRenderer.expandPath(path);
    }

    public void expandRow(int row) {
        this.treeAndTableCellRenderer.expandRow(row);
    }

    public Enumeration getExpandedDescendants(TreePath parent) {
        return this.treeAndTableCellRenderer.getExpandedDescendants(parent);
    }

    public TreePath getPathForRow(int row) {
        return this.treeAndTableCellRenderer.getPathForRow(row);
    }

    public boolean getShowsRootHandles() {
        return this.treeAndTableCellRenderer.getShowsRootHandles();
    }

    public Tree getTree() {
        return this.treeAndTableCellRenderer;
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.treeAndTableCellRenderer.getSelectionModel();
    }

    public TreeTableModel getTreeTableModel() {
        return this.getTreeTableModelAdapter().getTreeTableModel();
    }

    TreeTableModelAdapter getTreeTableModelAdapter() {
        return (TreeTableModelAdapter)this.getModel();
    }

    private final void init(TreeAndTableCellRenderer treeAndTableCellRenderer) {
        this.treeAndTableCellRenderer = treeAndTableCellRenderer;
        this.add(treeAndTableCellRenderer);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        if (treeAndTableCellRenderer != null) {
            treeAndTableCellRenderer.bind(this);
            treeAndTableCellRenderer.setSelectionModel(selectionWrapper);
        }
        treeAndTableCellRenderer.setRootVisible(true);
        this.setSelectionModel(selectionWrapper.getTableSelectionModel());
        this.setDefaultRenderer(AbstractTreeTableModel.hierarchicalColumnClass, treeAndTableCellRenderer);
    }

    public boolean isCollapsed(int row) {
        return this.treeAndTableCellRenderer.isCollapsed(row);
    }

    public boolean isCollapsed(TreePath path) {
        return this.treeAndTableCellRenderer.isCollapsed(path);
    }

    public boolean isExpanded(int row) {
        return this.treeAndTableCellRenderer.isExpanded(row);
    }

    public boolean isExpanded(TreePath path) {
        return this.treeAndTableCellRenderer.isExpanded(path);
    }

    public boolean isHierarchical(int column) {
        Class columnClass = this.getModel() != null ? this.getModel().getColumnClass(column) : null;
        return AbstractTreeTableModel.hierarchicalColumnClass.isAssignableFrom(columnClass);
    }

    public boolean isRootAutoExpanded() {
        return this.treeAndTableCellRenderer.isRootAutoExpanded();
    }

    public boolean isRootVisible() {
        return this.treeAndTableCellRenderer.isRootVisible();
    }

    public boolean isVisible(TreePath path) {
        return this.treeAndTableCellRenderer.isVisible(path);
    }

    public void processInput(String inputName, Object inputValue) {
        if (inputValue instanceof TreePath) {
            this.treeAndTableCellRenderer.processInput(inputName, inputValue);
        } else {
            super.processInput(inputName, inputValue);
        }
        if (this.getModel() == null) {
            return;
        }
    }

    public void setCellRenderer(TreeCellRenderer cellRenderer) {
        if (this.treeAndTableCellRenderer != null) {
            this.treeAndTableCellRenderer.setCellRenderer(cellRenderer);
        }
    }

    public final void setModel(TableModel tableModel) {
        if (tableModel instanceof TreeTableModelAdapter) {
            if (((TreeTableModelAdapter)tableModel).getTreeTable() != null) {
                throw new IllegalArgumentException("model already bound");
            }
        } else {
            throw new IllegalArgumentException("unsupported model type");
        }
        super.setModel(tableModel);
        ((TreeTableModelAdapter)tableModel).bind(this);
    }

    public void setRootAutoExpanded(boolean rootExpanded) {
        this.treeAndTableCellRenderer.setRootAutoExpanded(rootExpanded);
    }

    public void setRootVisible(boolean visible) {
        this.treeAndTableCellRenderer.setRootVisible(visible);
    }

    public void setSelectionMode(int mode) {
        if (this.treeAndTableCellRenderer != null) {
            switch (mode) {
                case 0: {
                    this.treeAndTableCellRenderer.getSelectionModel().setSelectionMode(2);
                    break;
                }
                case 2: {
                    this.treeAndTableCellRenderer.getSelectionModel().setSelectionMode(4);
                    break;
                }
                default: {
                    this.treeAndTableCellRenderer.getSelectionModel().setSelectionMode(1);
                }
            }
        }
        if (super.getSelectionModel() != null) {
            super.getSelectionModel().setSelectionMode(mode);
        }
    }

    public void setShowsRootHandles(boolean visible) {
        this.treeAndTableCellRenderer.setShowsRootHandles(visible);
    }

    public void setTreeTableModel(TreeTableModel treeModel) {
        this.treeAndTableCellRenderer.setModel(treeModel);
        this.setModel((TableModel)new TreeTableModelAdapter(treeModel, this.treeAndTableCellRenderer));
        if (treeModel != this.treeAndTableCellRenderer.getModel()) {
            throw new IllegalArgumentException("Mismatched TreeTableModel");
        }
    }

    public void validate() {
        super.validate();
    }

    static class TreeTableModelAdapter
    extends AbstractTableModel {
        private TreeTableModel model;
        private final Tree tree;
        private TreeTable treeTable = null;

        TreeTableModelAdapter(TreeTableModel model, Tree tree) {
            if (model == null) {
                throw new IllegalArgumentException("TreeTableModel model must be non null");
            }
            if (tree == null) {
                throw new IllegalArgumentException("TreeTableModel model must be non null");
            }
            this.tree = tree;
            this.model = model;
            model.addTreeModelListener(new TreeModelListener(this){
                private final /* synthetic */ TreeTableModelAdapter this$0;
                {
                    this.this$0 = this$0;
                }

                public void treeNodesChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.access$100(this.this$0, e, 0);
                }

                public void treeNodesInserted(TreeModelEvent e) {
                    TreeTableModelAdapter.access$100(this.this$0, e, 1);
                }

                public void treeNodesRemoved(TreeModelEvent e) {
                    TreeTableModelAdapter.access$100(this.this$0, e, 2);
                }

                public void treeStructureChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.access$200(this.this$0);
                }
            });
            tree.addTreeExpansionListener(new TreeExpansionListener(this){
                private final /* synthetic */ TreeTableModelAdapter this$0;
                {
                    this.this$0 = this$0;
                }

                public void treeCollapsed(TreeExpansionEvent event) {
                    this.this$0.fireTableDataChanged();
                }

                public void treeExpanded(TreeExpansionEvent event) {
                    this.this$0.fireTableDataChanged();
                }
            });
        }

        protected final void bind(TreeTable treeTable) {
            if (treeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("adapter already bound");
            }
            this.treeTable = treeTable;
        }

        private void delayedFireTableDataChanged() {
            this.fireTableDataChanged();
        }

        private void delayedFireTableDataChanged(TreeModelEvent tme, int typeChange) {
            int[] indices = tme.getChildIndices();
            TreePath path = tme.getTreePath();
            if (indices != null) {
                if (this.tree.isExpanded(path)) {
                    int startingRow = this.tree.getRowForPath(path) + 1;
                    int min = Integer.MAX_VALUE;
                    int max = Integer.MIN_VALUE;
                    for (int i = 0; i < indices.length; ++i) {
                        if (indices[i] < min) {
                            min = indices[i];
                        }
                        if (indices[i] <= max) continue;
                        max = indices[i];
                    }
                    switch (typeChange) {
                        case 0: {
                            this.fireTableRowsUpdated(startingRow + min, startingRow + max);
                            break;
                        }
                        case 1: {
                            this.fireTableRowsInserted(startingRow + min, startingRow + max);
                            break;
                        }
                        case 2: {
                            this.fireTableRowsDeleted(startingRow + min, startingRow + max);
                        }
                    }
                }
            } else {
                this.fireTableDataChanged();
            }
        }

        public Class getColumnClass(int column) {
            return this.model.getColumnClass(column);
        }

        public int getColumnCount() {
            return this.model.getColumnCount();
        }

        public String getColumnName(int column) {
            return this.model.getColumnName(column);
        }

        public int getRowCount() {
            return this.tree.getRowCount();
        }

        protected TreeTable getTreeTable() {
            return this.treeTable;
        }

        public TreeTableModel getTreeTableModel() {
            return this.model;
        }

        public Object getValueAt(int column, int row) {
            Object node = this.nodeForRow(row);
            return this.model.getValueAt(node, column);
        }

        Object nodeForRow(int row) {
            TreePath path = this.pathForRow(row);
            if (path != null) {
                return path.getLastPathComponent();
            }
            return null;
        }

        TreePath pathForRow(int row) {
            return this.tree.getPathForRow(row);
        }

        static /* synthetic */ void access$100(TreeTableModelAdapter x0, TreeModelEvent x1, int x2) {
            x0.delayedFireTableDataChanged(x1, x2);
        }

        static /* synthetic */ void access$200(TreeTableModelAdapter x0) {
            x0.delayedFireTableDataChanged();
        }
    }

    static class TreeTableCell
    extends Component {
        TreeTable treeTable;

        TreeTableCell(TreeTable treeTable, Tree tree, Object treeNode, TreePath treeNodePath, String displayValue) {
            this.treeTable = treeTable;
            this.setProperty("treeTable", treeTable);
            this.setProperty("tree", tree);
            this.setProperty("treeNode", treeNode);
            this.setProperty("treeNodePath", treeNodePath);
            this.setProperty("displayValue", displayValue);
        }

        public void processInput(String inputName, Object inputValue) {
            this.treeTable.processInput(inputName, inputValue);
        }
    }

    static class TreeAndTableCellRenderer
    extends Tree
    implements TableCellRenderer {
        static final Style DEFAULT_STYLE;
        private TreeTable treeTable;

        public TreeAndTableCellRenderer(TreeTableModel model) {
            super(model);
            this.setCellRenderer(new DefaultTreeCellRenderer());
        }

        public final void bind(TreeTable treeTable) {
            if (treeTable == null) {
                throw new IllegalArgumentException("TreeTable must not be null");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("TreeAndTableCellRenderer already bound");
            }
            this.treeTable = treeTable;
        }

        public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
            TreeTableModelAdapter tableModelAdapter = this.treeTable.getTreeTableModelAdapter();
            Object treeNode = tableModelAdapter.nodeForRow(row);
            TreePath treeNodePath = tableModelAdapter.pathForRow(row);
            String displayValue = value == null ? null : value.toString();
            TreeTableCell tableCell = new TreeTableCell(this.treeTable, this, treeNode, treeNodePath, displayValue);
            return tableCell;
        }

        static {
            MutableStyleEx style = new MutableStyleEx(Tree.DEFAULT_STYLE);
            style.setProperty("rootVisible", false);
            style.setProperty("showsRootHandles", true);
            DEFAULT_STYLE = style;
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel
    implements ChangeListener {
        ChangeListener listChangeListener;
        ListSelectionModel tableSelectionModel = new DefaultListSelectionModel();
        boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.tableSelectionModel.addChangeListener((ChangeListener)this);
        }

        ListSelectionModel getTableSelectionModel() {
            return this.tableSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        public void stateChanged(ChangeEvent e) {
            this.updateSelectedPathsFromSelectedRows();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.tableSelectionModel.getMinSelectedIndex();
                    int max = this.tableSelectionModel.getMaxSelectedIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.tableSelectionModel.isSelectedIndex(counter) || (selPath = TreeTable.this.treeAndTableCellRenderer.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }
    }
}

