/*
 * Decompiled with CFR 0.152.
 */
package echopointng.externalevent;

import echopointng.ExternalEventMonitor;
import echopointng.externalevent.ExternalEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.TaskQueueHandle;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.ServiceRegistry;
import nextapp.echo2.webrender.WebRenderServlet;

public class ExternalEventMonitorService
implements Service {
    public static final ExternalEventMonitorService INSTANCE = new ExternalEventMonitorService();
    private WeakHashMap weakInterestedParties = new WeakHashMap();
    private WeakHashMap weakInstanceQueues = new WeakHashMap();

    public String getId() {
        return "ExternalEvent";
    }

    public int getVersion() {
        return -1;
    }

    public synchronized void register(ExternalEventMonitor monitor) {
        this.weakInterestedParties.put(monitor, null);
    }

    public synchronized void deregister(ExternalEventMonitor monitor) {
        this.weakInterestedParties.remove((Object)monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Connection conn) throws IOException {
        HttpServletRequest request = conn.getRequest();
        ContainerInstance ci = (ContainerInstance)conn.getUserInstance();
        ApplicationInstance appInstance = ci.getApplicationInstance();
        if (appInstance != null) {
            ExternalEventMonitorService externalEventMonitorService = this;
            synchronized (externalEventMonitorService) {
                HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String paramName = (String)e.nextElement();
                    String[] paramValues = conn.getRequest().getParameterValues(paramName);
                    parameterMap.put(paramName, paramValues);
                }
                final ExternalEvent externalEvent = new ExternalEvent(this, parameterMap);
                TaskQueueHandle taskQueueHandle = (TaskQueueHandle)this.weakInstanceQueues.get(appInstance);
                if (taskQueueHandle == null) {
                    taskQueueHandle = appInstance.createTaskQueue();
                    this.weakInstanceQueues.put(appInstance, taskQueueHandle);
                }
                Set set = this.weakInterestedParties.keySet();
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    final ExternalEventMonitor monitor = (ExternalEventMonitor)((Object)iter.next());
                    if (!appInstance.equals(monitor.getApplicationInstance())) continue;
                    Runnable task = new Runnable(){

                        public void run() {
                            monitor.fireExternalEvent(externalEvent);
                        }
                    };
                    appInstance.enqueueTask(taskQueueHandle, task);
                }
            }
        }
        this.redirectToEchoApp(conn);
    }

    private void redirectToEchoApp(Connection conn) throws IOException {
        HttpServletRequest request = conn.getRequest();
        String uri = request.getRequestURI();
        StringBuffer parameters = new StringBuffer();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            String[] values = conn.getRequest().getParameterValues(paramName);
            if (paramName.equals("serviceId")) continue;
            for (int i = 0; i < values.length; ++i) {
                if (parameters.length() == 0) {
                    parameters.append('?');
                } else {
                    parameters.append('&');
                }
                parameters.append(paramName);
                parameters.append('=');
                parameters.append(values[i]);
            }
        }
        uri = uri + parameters.toString();
        conn.getResponse().sendRedirect(uri);
    }

    static {
        ServiceRegistry serviceRegistry = WebRenderServlet.getServiceRegistry();
        serviceRegistry.add((Service)INSTANCE);
    }
}

