/*
 * Decompiled with CFR 0.152.
 */
package echopointng.image;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

abstract class BaseImageEncoder
implements ImageConsumer {
    private static final ColorModel rgbModel = ColorModel.getRGBdefault();
    private boolean accumulate = false;
    private int[] accumulator;
    private boolean encoding;
    private int height = -1;
    private int hintflags = 0;
    private IOException iox;
    protected OutputStream out;
    private ImageProducer producer;
    private boolean started = false;
    private int width = -1;

    public BaseImageEncoder(Image img, OutputStream out) {
        this(img.getSource(), out);
    }

    public BaseImageEncoder(ImageProducer producer, OutputStream out) {
        this.producer = producer;
        this.out = out;
    }

    public synchronized void encode() throws IOException {
        this.encoding = true;
        this.iox = null;
        this.producer.startProduction(this);
        while (this.encoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.iox != null) {
            throw this.iox;
        }
    }

    abstract void encodeDone() throws IOException;

    private void encodeFinish() throws IOException {
        if (this.accumulate) {
            this.encodePixels(0, 0, this.width, this.height, this.accumulator, 0, this.width);
            this.accumulator = null;
            this.accumulate = false;
        }
    }

    abstract void encodePixels(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7) throws IOException;

    private void encodePixelsWrapper(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        if (!this.started) {
            this.started = true;
            this.encodeStart(this.width, this.height);
            if ((this.hintflags & 2) == 0) {
                this.accumulate = true;
                this.accumulator = new int[this.width * this.height];
            }
        }
        if (this.accumulate) {
            for (int row = 0; row < h; ++row) {
                System.arraycopy(rgbPixels, row * scansize + off, this.accumulator, (y + row) * this.width + x, w);
            }
        } else {
            this.encodePixels(x, y, w, h, rgbPixels, off, scansize);
        }
    }

    abstract void encodeStart(int var1, int var2) throws IOException;

    public void imageComplete(int status) {
        this.producer.removeConsumer(this);
        if (status == 4) {
            this.iox = new IOException("image aborted");
        } else {
            try {
                this.encodeFinish();
                this.encodeDone();
            }
            catch (IOException e) {
                this.iox = e;
            }
        }
        this.stop();
    }

    public void setColorModel(ColorModel model) {
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setHints(int hintflags) {
        this.hintflags = hintflags;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int[] rgbPixels = new int[w];
        for (int row = 0; row < h; ++row) {
            int rowOff = off + row * scansize;
            for (int col = 0; col < w; ++col) {
                rgbPixels[col] = model.getRGB(pixels[rowOff + col] & 0xFF);
            }
            try {
                this.encodePixelsWrapper(x, y + row, w, 1, rgbPixels, 0, w);
                continue;
            }
            catch (IOException e) {
                this.iox = e;
                this.stop();
                return;
            }
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (model == rgbModel) {
            try {
                this.encodePixelsWrapper(x, y, w, h, pixels, off, scansize);
            }
            catch (IOException e) {
                this.iox = e;
                this.stop();
                return;
            }
        } else {
            int[] rgbPixels = new int[w];
            for (int row = 0; row < h; ++row) {
                int rowOff = off + row * scansize;
                for (int col = 0; col < w; ++col) {
                    rgbPixels[col] = model.getRGB(pixels[rowOff + col]);
                }
                try {
                    this.encodePixelsWrapper(x, y + row, w, 1, rgbPixels, 0, w);
                    continue;
                }
                catch (IOException e) {
                    this.iox = e;
                    this.stop();
                    return;
                }
            }
        }
    }

    public void setProperties(Hashtable props) {
    }

    private synchronized void stop() {
        this.encoding = false;
        this.notifyAll();
    }
}

