/*
 * Decompiled with CFR 0.152.
 */
package echopointng.image;

import echopointng.image.GifEncoder;
import echopointng.image.ImageEncoder;
import echopointng.image.ImageKit;
import echopointng.image.PngEncoder;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.StreamImageReference;

public class EncodedImageReference
extends StreamImageReference
implements Serializable {
    private transient ImageEncoder encoder;
    private transient Image internalImage;
    private boolean keptInMemory;
    private transient SoftReference refEncodedBytes;
    private boolean valid;
    private String id = ApplicationInstance.generateSystemId();

    public EncodedImageReference() {
        this(null);
    }

    public EncodedImageReference(Image image) {
        this.internalImage = image;
        this.encoder = image != null && ImageKit.hasAlphaChannel(image) ? new GifEncoder() : new PngEncoder();
        this.refEncodedBytes = new SoftReference<Object>(null);
        this.keptInMemory = false;
        this.valid = false;
    }

    public String getRenderId() {
        return this.id;
    }

    public String getContentType() {
        return this.encoder.getContentType();
    }

    public ImageEncoder getEncoder() {
        return this.encoder;
    }

    public Extent getHeight() {
        Image image = this.getImage();
        if (image != null) {
            return new Extent(image.getHeight(ImageKit.imageObserver));
        }
        return super.getHeight();
    }

    public Image getImage() {
        return this.internalImage;
    }

    public Extent getWidth() {
        Image image = this.getImage();
        if (image != null) {
            return new Extent(image.getWidth(ImageKit.imageObserver));
        }
        return super.getWidth();
    }

    public boolean isKeptInMemory() {
        return this.keptInMemory;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Class encoderClass = (Class)in.readObject();
        try {
            this.encoder = (ImageEncoder)encoderClass.newInstance();
        }
        catch (Exception e) {
            throw new IOException("Unable to instanstiate the encoder class : " + encoderClass.getName() + " : " + e.toString());
        }
        this.valid = false;
        this.refEncodedBytes = new SoftReference<Object>(null);
        this.internalImage = ImageKit.readSerializedImage(in);
    }

    public void render(OutputStream out) throws IOException {
        if (this.isKeptInMemory()) {
            byte[] bytes = (byte[])this.refEncodedBytes.get();
            if (bytes == null || !this.isValid()) {
                Image image = this.getImage();
                if (image == null) {
                    return;
                }
                ByteArrayOutputStream ba = new ByteArrayOutputStream();
                this.encoder.encode(image, ba);
                bytes = ba.toByteArray();
                this.refEncodedBytes = new SoftReference<byte[]>(bytes);
                this.setValid(true);
                this.update();
            }
            out.write(bytes);
        } else {
            Image image = this.getImage();
            if (image == null) {
                return;
            }
            this.encoder.encode(image, out);
        }
    }

    public void setEncoder(ImageEncoder encoder) {
        if (encoder == null) {
            throw new IllegalArgumentException("The Encoder must be non null!");
        }
        ImageEncoder oldValue = this.encoder;
        this.encoder = encoder;
        if (oldValue != this.encoder) {
            this.valid = false;
            this.update();
        }
    }

    public void setImage(Image image) {
        Image oldValue = this.internalImage;
        this.internalImage = image;
        if (oldValue != image) {
            this.valid = false;
            this.update();
        }
    }

    public void setKeptInMemory(boolean b) {
        boolean oldValue = this.keptInMemory;
        this.keptInMemory = b;
        if (oldValue != this.keptInMemory) {
            this.valid = false;
            this.update();
        }
    }

    public void setValid(boolean valid) {
        boolean oldValue = this.valid;
        this.valid = valid;
        if (valid != oldValue) {
            this.update();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.encoder.getClass());
        ImageKit.writeSerializedImage(out, this.getImage());
    }

    public void update() {
    }
}

