/*
 * Decompiled with CFR 0.152.
 */
package echopointng.richtext;

import echopointng.richtext.RichTextSpellChecker;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;

public abstract class AbstractRichTextSpellChecker
implements RichTextSpellChecker {
    public RichTextSpellChecker.SpellCheckerWord[] parseWords(String textBuffer) {
        ArrayList<SpellCheckerWordImpl> wordList = new ArrayList<SpellCheckerWordImpl>();
        CountedReader cr = new CountedReader(textBuffer.toCharArray());
        StreamTokenizer st = new StreamTokenizer(cr);
        int lastPos = 0;
        int tt = 0;
        try {
            tt = st.nextToken();
            while (tt != -1) {
                String token = "";
                switch (tt) {
                    case -3: {
                        token = st.sval;
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        token = new String(new char[]{(char)tt});
                    }
                }
                String generalWord = textBuffer.substring(lastPos, cr.getPos());
                int startIndex = lastPos + generalWord.indexOf(token);
                int endIndex = startIndex + token.length();
                SpellCheckerWordImpl word = new SpellCheckerWordImpl(textBuffer, startIndex, endIndex);
                wordList.add(word);
                lastPos = cr.getPos();
                tt = st.nextToken();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return wordList.toArray(new RichTextSpellChecker.SpellCheckerWord[wordList.size()]);
    }

    private class SpellCheckerWordImpl
    implements RichTextSpellChecker.SpellCheckerWord {
        private int startIndex;
        private int endIndex;
        private String word;

        private SpellCheckerWordImpl(String textBuffer, int startIndex, int endIndex) {
            this.endIndex = endIndex;
            this.startIndex = startIndex;
            this.word = textBuffer.substring(startIndex, endIndex);
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.word);
            sb.append(" @ si:");
            sb.append(this.startIndex);
            sb.append(" ei:");
            sb.append(this.endIndex);
            return sb.toString();
        }
    }

    private class CountedReader
    extends CharArrayReader {
        public CountedReader(char[] buf) {
            super(buf);
        }

        public int getPos() {
            return this.pos;
        }
    }
}

