/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class CssObjectIntrospector {
    private static final Map classLoaderCache = new WeakHashMap();
    private Map propertyDescriptorMap = new HashMap();
    private Class introspectedClass;
    private Map constants;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CssObjectIntrospector forName(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        CssObjectIntrospector ci;
        HashMap<String, CssObjectIntrospector> ciStore;
        Map map = classLoaderCache;
        synchronized (map) {
            ciStore = (HashMap<String, CssObjectIntrospector>)classLoaderCache.get(classLoader);
            if (ciStore == null) {
                ciStore = new HashMap<String, CssObjectIntrospector>();
                classLoaderCache.put(classLoader, ciStore);
            }
        }
        HashMap<String, CssObjectIntrospector> hashMap = ciStore;
        synchronized (hashMap) {
            ci = (CssObjectIntrospector)ciStore.get(typeName);
            if (ci == null) {
                ci = new CssObjectIntrospector(typeName, classLoader);
                ciStore.put(typeName, ci);
            }
        }
        return ci;
    }

    private CssObjectIntrospector(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        this.introspectedClass = Class.forName(typeName, true, classLoader);
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.introspectedClass, 3);
            this.loadPropertyData(beanInfo);
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException("Introspection Error", ex);
        }
    }

    public Class getIntrospectedClass() {
        return this.introspectedClass;
    }

    public Iterator getConstantNames() {
        return this.constants.keySet().iterator();
    }

    public Object getConstantValue(String constantName) {
        return this.constants.get(constantName);
    }

    public Class getPropertyClass(String propertyName) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedPropertyType();
        }
        return propertyDescriptor.getPropertyType();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return (PropertyDescriptor)this.propertyDescriptorMap.get(propertyName);
    }

    public Method getWriteMethod(String propertyName) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedWriteMethod();
        }
        return propertyDescriptor.getWriteMethod();
    }

    public boolean isIndexedProperty(String propertyName) {
        return this.propertyDescriptorMap.get(propertyName) instanceof IndexedPropertyDescriptor;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("CssObjectIntrospector : [");
        buf.append(this.introspectedClass.getName());
        buf.append(']');
        return buf.toString();
    }

    private void loadPropertyData(BeanInfo beanInfo) {
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int index = 0; index < propertyDescriptors.length; ++index) {
            String name;
            if (propertyDescriptors[index] instanceof IndexedPropertyDescriptor) {
                if (((IndexedPropertyDescriptor)propertyDescriptors[index]).getIndexedWriteMethod() == null) continue;
                name = propertyDescriptors[index].getName();
                this.propertyDescriptorMap.put(name, propertyDescriptors[index]);
                continue;
            }
            if (propertyDescriptors[index].getWriteMethod() == null && propertyDescriptors[index].getReadMethod() == null || (name = propertyDescriptors[index].getName()).equals("class")) continue;
            this.propertyDescriptorMap.put(name, propertyDescriptors[index]);
        }
    }

    public Constructor getConstructor(Object[] propertyValues) {
        Class[] targetTypes = new Class[propertyValues.length];
        for (int i = 0; i < propertyValues.length; ++i) {
            targetTypes[i] = propertyValues[i] == null ? null : propertyValues[i].getClass();
        }
        try {
            return this.introspectedClass.getConstructor(targetTypes);
        }
        catch (Exception e) {
            Constructor<?>[] constructors = this.introspectedClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Class<?>[] parameterTypes = constructors[i].getParameterTypes();
                if (targetTypes.length != parameterTypes.length) continue;
                boolean matches = true;
                for (int j = 0; j < parameterTypes.length; ++j) {
                    if (targetTypes[j] == null) {
                        if (!parameterTypes[j].isPrimitive()) continue;
                        matches = false;
                        break;
                    }
                    if (parameterTypes[j].isAssignableFrom(targetTypes[j]) || this.matchesPrimiteClass(parameterTypes[j], targetTypes[j])) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                return constructors[i];
            }
            return null;
        }
    }

    private boolean matchesPrimiteClass(Class parameterType, Class targetType) {
        if (!parameterType.isPrimitive()) {
            return false;
        }
        if (parameterType.equals(Character.TYPE)) {
            return targetType.equals(Character.class);
        }
        if (parameterType.equals(Byte.TYPE)) {
            return targetType.equals(Byte.class);
        }
        if (parameterType.equals(Short.TYPE)) {
            return targetType.equals(Short.class);
        }
        if (parameterType.equals(Integer.TYPE)) {
            return targetType.equals(Integer.class);
        }
        if (parameterType.equals(Long.TYPE)) {
            return targetType.equals(Long.class);
        }
        if (parameterType.equals(Float.TYPE)) {
            return targetType.equals(Float.class);
        }
        if (parameterType.equals(Double.TYPE)) {
            return targetType.equals(Double.class);
        }
        return false;
    }
}

