/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet;

import echopointng.stylesheet.CssClassDecl;
import echopointng.stylesheet.CssStyleSetter;
import echopointng.stylesheet.CssStyleSheetException;
import echopointng.stylesheet.CssStyleSheetParser;
import echopointng.util.reflect.ReflectionKit;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.MutableStyle;
import nextapp.echo2.app.MutableStyleSheet;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.StyleSheet;

public class CssStyleSheetLoader {
    private static final Style EMPTY_STYLE = new MutableStyle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StyleSheet load(String resourceName, ClassLoader classLoader) throws CssStyleSheetException {
        StyleSheet styleSheet;
        block5: {
            InputStream in = null;
            try {
                in = classLoader.getResourceAsStream(resourceName);
                styleSheet = CssStyleSheetLoader.load(in, classLoader);
                Object var5_4 = null;
                if (in == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (in == null) break block6;
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return styleSheet;
    }

    public static StyleSheet load(InputStream in, ClassLoader classLoader) throws CssStyleSheetException {
        CssStyleSheetParser parser = new CssStyleSheetParser(in);
        parser.parse();
        CssClassDecl[] classEntries = parser.getClassEntries();
        HashMap<String, CssClassDecl> cssClassDeclMap = new HashMap<String, CssClassDecl>();
        HashMap<String, MutableStyle> componentClassToStyleMap = new HashMap<String, MutableStyle>();
        for (int i = 0; i < classEntries.length; ++i) {
            CssClassDecl currentCE = classEntries[i];
            int lineNo = currentCE.getLineNo();
            String componentClassName = currentCE.getClassName();
            try {
                Class<?> componentClass = Class.forName(componentClassName, true, classLoader);
                currentCE.setComponentClass(componentClass);
                currentCE.setClassName(componentClass.getName());
                if ((class$nextapp$echo2$app$Component == null ? CssStyleSheetLoader.class$("nextapp.echo2.app.Component") : class$nextapp$echo2$app$Component).isAssignableFrom(componentClass)) continue;
                throw new CssStyleSheetException("The class is no derived from nextapp.echo2.app.Component: " + componentClassName, null, lineNo);
            }
            catch (ClassNotFoundException ex) {
                throw new CssStyleSheetException("Cannot load class: " + componentClassName, ex, lineNo);
            }
        }
        Arrays.sort(classEntries, new CssComponentClassComparator());
        MutableStyleSheet styleSheet = new MutableStyleSheet();
        for (int i = 0; i < classEntries.length; ++i) {
            CssClassDecl currentCE = classEntries[i];
            int lineNo = currentCE.getLineNo();
            String componentClassName = currentCE.getClassName();
            String styleName = currentCE.getStyleName();
            String fullStyleName = componentClassName;
            if (styleName != null) {
                fullStyleName = fullStyleName + '#' + styleName;
            }
            if (cssClassDeclMap.containsKey(fullStyleName)) {
                throw new CssStyleSheetException("Duplicate style declaration encountered " + fullStyleName, null, lineNo);
            }
            cssClassDeclMap.put(fullStyleName, currentCE);
            MutableStyle style = CssStyleSheetLoader.populateDerivedStyle(currentCE, componentClassToStyleMap);
            if (currentCE.getExtendsStyleName() != null) {
                String extendsStyleName = currentCE.getExtendsStyleName();
                String fullExtendsStyleName = componentClassName + '#' + extendsStyleName;
                Style extendsStyle = CssStyleSheetLoader.findExtendsStyle(currentCE, componentClassToStyleMap, cssClassDeclMap);
                if (extendsStyle == null) {
                    throw new CssStyleSheetException("Invalid 'extends' style name '" + fullExtendsStyleName + "' for style name " + fullStyleName, null, lineNo);
                }
                style.addStyleContent(extendsStyle);
            }
            CssStyleSetter styleSetter = new CssStyleSetter();
            Style propertyStyle = styleSetter.createStyle(currentCE, classLoader);
            style.addStyleContent(propertyStyle);
            componentClassToStyleMap.put(fullStyleName, style);
            styleSheet.addStyle(currentCE.getComponentClass(), styleName, (Style)style);
        }
        return styleSheet;
    }

    private static MutableStyle populateDerivedStyle(CssClassDecl currentCE, Map componentClassToStyleMap) {
        MutableStyle style = new MutableStyle();
        Class[] classes = ReflectionKit.getClassHierarchy(currentCE.getComponentClass(), Component.class);
        for (int i = classes.length - 1; i >= 0; --i) {
            String componentClassName = classes[i].getName();
            Style classStyle = (Style)componentClassToStyleMap.get(componentClassName);
            if (classStyle == null) continue;
            style.addStyleContent(classStyle);
        }
        return style;
    }

    private static Style findExtendsStyle(CssClassDecl currentCE, Map componentClassToStyleMap, Map cssComponentClassMap) {
        String extendsStyleName = currentCE.getExtendsStyleName();
        Class[] classes = ReflectionKit.getClassHierarchy(currentCE.getComponentClass(), Component.class);
        for (int i = 0; i < classes.length; ++i) {
            String componentClassName = classes[i].getName();
            String fullExtendsClassName = "itself".equals(extendsStyleName) ? componentClassName : componentClassName + '#' + extendsStyleName;
            Style classStyle = (Style)componentClassToStyleMap.get(fullExtendsClassName);
            if (classStyle == null) continue;
            return classStyle;
        }
        if ("itself".equals(extendsStyleName)) {
            return EMPTY_STYLE;
        }
        return null;
    }

    private static class CssComponentClassComparator
    implements Comparator {
        private CssComponentClassComparator() {
        }

        public int compare(Object o1, Object o2) {
            CssClassDecl te1 = (CssClassDecl)o1;
            CssClassDecl te2 = (CssClassDecl)o2;
            if (te1 == te2) {
                return 0;
            }
            Class class1 = te1.getComponentClass();
            Class class2 = te2.getComponentClass();
            String styleName1 = te1.getStyleName();
            String styleName2 = te2.getStyleName();
            if (class1.equals(class2)) {
                if (styleName1 == null && styleName2 == null) {
                    return 0;
                }
                if (styleName1 != null && styleName1.equals(te2.getExtendsStyleName())) {
                    return -1;
                }
                if (styleName2 != null && styleName2.equals(te1.getExtendsStyleName())) {
                    return 1;
                }
                if (styleName1 != null) {
                    if (styleName2 != null) {
                        return styleName1.compareTo(styleName2);
                    }
                    return 1;
                }
                return -1;
            }
            if (class1.isAssignableFrom(class2)) {
                return -1;
            }
            if (class2.isAssignableFrom(class1)) {
                return 1;
            }
            return te1.getClassName().compareTo(te2.getClassName());
        }
    }
}

