/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet.test;

import echopointng.stylesheet.CssInvalidValueException;
import echopointng.stylesheet.CssPropertyPeer;
import echopointng.stylesheet.CssPropertyPeerLoader;
import echopointng.stylesheet.propertypeer.AlignmentPeer;
import echopointng.stylesheet.propertypeer.BooleanPeer;
import echopointng.stylesheet.propertypeer.BorderPeer;
import echopointng.stylesheet.propertypeer.BytePeer;
import echopointng.stylesheet.propertypeer.CharacterPeer;
import echopointng.stylesheet.propertypeer.ColorPeer;
import echopointng.stylesheet.propertypeer.DoublePeer;
import echopointng.stylesheet.propertypeer.ExtentPeer;
import echopointng.stylesheet.propertypeer.FloatPeer;
import echopointng.stylesheet.propertypeer.FontPeer;
import echopointng.stylesheet.propertypeer.InsetsPeer;
import echopointng.stylesheet.propertypeer.IntegerPeer;
import echopointng.stylesheet.propertypeer.LocalePeer;
import echopointng.stylesheet.propertypeer.LongPeer;
import echopointng.stylesheet.propertypeer.ShortPeer;
import echopointng.stylesheet.propertypeer.StringPeer;
import echopointng.stylesheet.propertypeer.TypefacePeer;
import java.util.Locale;
import junit.framework.TestCase;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.HttpImageReference;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;

public class CssTestPropertyPeers
extends TestCase {
    private Extent pt8 = new Extent(8, 4);
    private Extent px12 = new Extent(12, 1);

    public void testPropertyPeers() {
        this.testReversability(AlignmentPeer.class, new Alignment(3, 6), "alignment(LEFT,TOP)");
        this.testReversability(BooleanPeer.class, true, "true");
        this.testReversability(BorderPeer.class, new Border(this.pt8, Color.RED, 2), "border(8pt,#FF0000,STYLE_INSET)");
        this.testReversability(BytePeer.class, new Byte(127), "127");
        this.testReversability(CharacterPeer.class, new Character('z'), "z");
        this.testReversability(ColorPeer.class, Color.BLUE, "#0000FF");
        this.testReversability(DoublePeer.class, new Double(66.66), "66.66");
        this.testReversability(ExtentPeer.class, this.pt8, "8pt");
        this.testReversability(FloatPeer.class, new Float(0.1), "0.1");
        this.testReversability(FontPeer.class, new Font(Font.ARIAL, 1, this.pt8), "font('Arial, Helvetica, Sans-Serif',BOLD,8pt)");
        this.testReversability(InsetsPeer.class, new Insets(1, 2, 3, 4), "insets(1px,2px,3px,4px)");
        this.testReversability(IntegerPeer.class, new Integer(234), "234");
        this.testReversability(LocalePeer.class, Locale.US, "en_US");
        this.testReversability(LongPeer.class, new Long(9988L), "9988");
        this.testReversability(ShortPeer.class, new Short(Short.MAX_VALUE), "32767");
        this.testReversability(StringPeer.class, "identity", "identity");
        this.testReversability(TypefacePeer.class, Font.ARIAL, "typeface('Arial, Helvetica, Sans-Serif')");
    }

    public void testImagePropertyPeers() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        CssPropertyPeer peer = this.getPeer(FillImage.class);
        CssTestPropertyPeers.assertNotNull((Object)peer);
        FillImage startVal = new FillImage((ImageReference)new HttpImageReference("imageUrl.gif", this.pt8, this.px12), this.pt8, this.px12, 1);
        String startStr = "fillimage(image('imageUrl.gif',8pt,12px),8pt,12px,REPEAT_HORIZONTAL,ATTACHMENT_FIXED)";
        try {
            FillImage convertedValue = (FillImage)peer.getJavaObject(classLoader, FillImage.class, startStr, 0);
            String convertedString = peer.getStyleString(classLoader, FillImage.class, startVal);
            CssTestPropertyPeers.assertEquals((String)startStr, (String)convertedString);
            CssTestPropertyPeers.assertEquals((Object)startVal.getHorizontalOffset(), (Object)convertedValue.getHorizontalOffset());
            CssTestPropertyPeers.assertEquals((int)startVal.getRepeat(), (int)convertedValue.getRepeat());
            CssTestPropertyPeers.assertEquals((Object)startVal.getVerticalOffset(), (Object)convertedValue.getVerticalOffset());
        }
        catch (CssInvalidValueException e) {
            CssTestPropertyPeers.assertTrue((boolean)false);
        }
        peer = this.getPeer(HttpImageReference.class);
        CssTestPropertyPeers.assertNotNull((Object)peer);
        HttpImageReference startImage = new HttpImageReference("urlImage.gif", this.pt8, this.px12);
        String startImageStr = "image('urlImage.gif',8pt,12px)";
        try {
            HttpImageReference convertedValue = (HttpImageReference)peer.getJavaObject(classLoader, HttpImageReference.class, startImageStr, 0);
            String convertedString = peer.getStyleString(classLoader, HttpImageReference.class, startImage);
            CssTestPropertyPeers.assertEquals((String)startImageStr, (String)convertedString);
            CssTestPropertyPeers.assertEquals((String)startImage.getUri(), (String)convertedValue.getUri());
            CssTestPropertyPeers.assertEquals((Object)startImage.getHeight(), (Object)convertedValue.getHeight());
            CssTestPropertyPeers.assertEquals((Object)startImage.getWidth(), (Object)convertedValue.getWidth());
        }
        catch (CssInvalidValueException e) {
            CssTestPropertyPeers.assertTrue((boolean)false);
        }
    }

    private void testReversability(Class propertyPeerClass, Object realValue, String propertyValue) {
        Class<?> objectClass = realValue.getClass();
        ClassLoader classLoader = objectClass.getClassLoader();
        CssPropertyPeer peer = this.getPeer(objectClass);
        CssTestPropertyPeers.assertNotNull((Object)peer);
        try {
            Object testValue = peer.getJavaObject(classLoader, objectClass, propertyValue, 0);
            CssTestPropertyPeers.assertEquals((Object)testValue, (Object)realValue);
            String testString = peer.getStyleString(classLoader, objectClass, realValue);
            CssTestPropertyPeers.assertEquals((String)testString, (String)propertyValue);
            realValue = peer.getJavaObject(classLoader, objectClass, testString, 0);
            CssTestPropertyPeers.assertEquals((Object)testValue, (Object)realValue);
            propertyValue = peer.getStyleString(classLoader, objectClass, testValue);
            CssTestPropertyPeers.assertEquals((String)testString, (String)propertyValue);
        }
        catch (CssInvalidValueException e) {
            CssTestPropertyPeers.assertEquals((String)"caused", (String)e.getMessage());
        }
    }

    private CssPropertyPeer getPeer(Class objectClass) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        CssPropertyPeerLoader loader = CssPropertyPeerLoader.forClassLoader(classLoader);
        CssPropertyPeer peer = loader.getPropertyPeer(objectClass);
        return peer;
    }
}

