/*
 * Decompiled with CFR 0.152.
 */
package echopointng.table;

import echopointng.list.ListSelectionModelEx;
import echopointng.table.PageableTableModel;
import echopointng.table.SortableTableModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EventListener;
import java.util.List;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;
import nextapp.echo2.app.event.EventListenerList;
import nextapp.echo2.app.table.TableModel;

public class AbleTableSelectionModel
implements ListSelectionModelEx,
Serializable {
    private EventListenerList listenerList = new EventListenerList();
    private int selectionMode = 0;
    private BitSet selection = new BitSet();
    private int minSelectedUnsortedIndex = -1;
    private TableModel tableModel;
    private boolean suppressChangeNotifications = false;

    public AbleTableSelectionModel(TableModel tableModel) {
        this.tableModel = tableModel;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.addListener(ChangeListener.class, (EventListener)l);
    }

    public void clearSelection() {
        this.selection = new BitSet();
        this.minSelectedUnsortedIndex = -1;
        this.fireValueChanged();
    }

    protected void fireValueChanged() {
        if (this.suppressChangeNotifications) {
            return;
        }
        ChangeEvent e = new ChangeEvent((Object)this);
        EventListener[] listeners = this.listenerList.getListeners(ChangeListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((ChangeListener)listeners[index]).stateChanged(e);
        }
    }

    private int toSortedViewRowIndex(int modelRowIndex) {
        if (this.tableModel instanceof SortableTableModel) {
            return ((SortableTableModel)this.tableModel).toSortedViewRowIndex(modelRowIndex);
        }
        return modelRowIndex;
    }

    private int toUnsortedModelRowIndex(int viewRowIndex) {
        if (this.tableModel instanceof SortableTableModel) {
            return ((SortableTableModel)this.tableModel).toUnsortedModelRowIndex(viewRowIndex);
        }
        return viewRowIndex;
    }

    private int toPagedViewRowIndex(int modelRowIndex) {
        if (this.tableModel instanceof PageableTableModel) {
            return ((PageableTableModel)this.tableModel).toPagedViewRowIndex(modelRowIndex);
        }
        return modelRowIndex;
    }

    private int toUnpagedModelRowIndex(int viewRowIndex) {
        if (this.tableModel instanceof PageableTableModel) {
            return ((PageableTableModel)this.tableModel).toUnpagedModelRowIndex(viewRowIndex);
        }
        return viewRowIndex;
    }

    public int getMaxSelectedIndex() {
        int maxSelectedSortedIndex = this.selection.length() == 0 ? -1 : Integer.MIN_VALUE;
        int[] selectedViewIndices = this.getSelectedIndices();
        for (int i = 0; i < selectedViewIndices.length; ++i) {
            int viewRowIndex = selectedViewIndices[i];
            if (viewRowIndex <= maxSelectedSortedIndex) continue;
            maxSelectedSortedIndex = viewRowIndex;
        }
        maxSelectedSortedIndex = maxSelectedSortedIndex == Integer.MIN_VALUE ? -1 : maxSelectedSortedIndex;
        return maxSelectedSortedIndex;
    }

    public int getMinSelectedIndex() {
        int minSelectedSortedIndex = this.selection.length() == 0 ? -1 : Integer.MAX_VALUE;
        int[] selectedViewIndices = this.getSelectedIndices();
        for (int i = 0; i < selectedViewIndices.length; ++i) {
            int viewRowIndex = selectedViewIndices[i];
            if (viewRowIndex >= minSelectedSortedIndex) continue;
            minSelectedSortedIndex = viewRowIndex;
        }
        minSelectedSortedIndex = minSelectedSortedIndex == Integer.MAX_VALUE ? -1 : minSelectedSortedIndex;
        return minSelectedSortedIndex;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public boolean isSelectedIndex(int viewRowIndex) {
        try {
            int rowIndex = this.toUnpagedModelRowIndex(viewRowIndex);
            rowIndex = this.toUnsortedModelRowIndex(rowIndex);
            boolean selected = this.selection.get(rowIndex);
            return selected;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public boolean isSelectedModelIndex(int modelRowIndex) {
        try {
            boolean selected = this.selection.get(modelRowIndex);
            return selected;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public boolean isSelectionEmpty() {
        return this.selection.length() == 0;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.removeListener(ChangeListener.class, (EventListener)l);
    }

    public void setSelectedIndex(int viewRowIndex, boolean newValue) {
        try {
            int rowIndex = this.toUnpagedModelRowIndex(viewRowIndex);
            rowIndex = this.toUnsortedModelRowIndex(rowIndex);
            this.setSelectedUnsortedIndex(rowIndex, newValue);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void setSelectedIndices(int[] selectedIndices, boolean selected) {
        this.suppressChangeNotifications = true;
        for (int i = 0; i < selectedIndices.length; ++i) {
            this.setSelectedIndex(selectedIndices[i], selected);
        }
        this.suppressChangeNotifications = false;
        this.fireValueChanged();
    }

    private void setSelectedUnsortedIndex(int unsortedIndex, boolean newValue) {
        block3: {
            block5: {
                block4: {
                    boolean oldValue = this.selection.get(unsortedIndex);
                    if (!(newValue ^ oldValue)) break block3;
                    if (!newValue) break block4;
                    if (this.selectionMode == 0 && this.getMinSelectedIndex() != -1) {
                        this.setSelectedUnsortedIndex(this.minSelectedUnsortedIndex, false);
                    }
                    this.selection.set(unsortedIndex);
                    if (unsortedIndex >= this.minSelectedUnsortedIndex && this.minSelectedUnsortedIndex != -1) break block5;
                    this.minSelectedUnsortedIndex = unsortedIndex;
                    break block5;
                }
                this.selection.clear(unsortedIndex);
                if (unsortedIndex == this.minSelectedUnsortedIndex) {
                    int max = this.selection.length() - 1;
                    this.minSelectedUnsortedIndex = -1;
                    for (int i = 0; i <= max; ++i) {
                        if (!this.selection.get(i)) continue;
                        this.minSelectedUnsortedIndex = i;
                        break;
                    }
                }
            }
            this.fireValueChanged();
        }
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode != 2 && this.selectionMode == 2) {
            int maxSelectedIndex = this.selection.length() - 1;
            for (int i = this.minSelectedUnsortedIndex + 1; i <= maxSelectedIndex; ++i) {
                this.setSelectedUnsortedIndex(i, false);
            }
        }
        this.selectionMode = selectionMode;
        this.fireValueChanged();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(in model space) ");
        if (this.tableModel != null) {
            int len = this.tableModel.getRowCount();
            for (int i = 0; i < len; ++i) {
                if (!this.selection.get(i)) continue;
                buf.append(i);
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public int[] getSelectedIndices() {
        int rowCount = this.tableModel.getRowCount();
        ArrayList<Integer> selectedIndexList = new ArrayList<Integer>();
        for (int modelRowIndex = 0; modelRowIndex < this.selection.length(); ++modelRowIndex) {
            try {
                int viewRowIndex = this.toSortedViewRowIndex(modelRowIndex);
                viewRowIndex = this.toPagedViewRowIndex(viewRowIndex);
                if (viewRowIndex < 0 || viewRowIndex >= rowCount || !this.selection.get(modelRowIndex)) continue;
                selectedIndexList.add(new Integer(viewRowIndex));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        return this.toIntArrayFromIntegerList(selectedIndexList);
    }

    public int[] getSelectedModelIndices() {
        ArrayList<Integer> selectedIndexList = new ArrayList<Integer>();
        for (int modelRowIndex = 0; modelRowIndex < this.selection.length(); ++modelRowIndex) {
            try {
                if (!this.selection.get(modelRowIndex)) continue;
                selectedIndexList.add(new Integer(modelRowIndex));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return this.toIntArrayFromIntegerList(selectedIndexList);
    }

    private int[] toIntArrayFromIntegerList(List integerList) {
        if (integerList == null) {
            return new int[0];
        }
        int[] ints = new int[integerList.size()];
        for (int i = 0; i < integerList.size(); ++i) {
            ints[i] = (Integer)integerList.get(i);
        }
        return ints;
    }
}

