/*
 * Decompiled with CFR 0.152.
 */
package echopointng.table;

import echopointng.table.SortableTableColumn;
import echopointng.table.SortableTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.event.TableModelEvent;
import nextapp.echo2.app.event.TableModelListener;
import nextapp.echo2.app.table.AbstractTableModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import nextapp.echo2.app.table.TableModel;

public class DefaultSortableTableModel
extends AbstractTableModel
implements SortableTableModel {
    protected TableModel underlyingTableModel;
    public static final Comparator COMPARABLE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private TableColumnModel columnModel;
    private SortedRow[] viewToModel;
    private int[] modelToView;
    private TableModelListener tableModelListener = new TableModelHandler();
    private Map columnComparators = new HashMap();
    private List sortingColumns = new ArrayList();
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);

    public DefaultSortableTableModel(TableModel underlyingTableModel) {
        this(underlyingTableModel, null);
    }

    public DefaultSortableTableModel(TableModel underlyingTableModel, TableColumnModel columnModel) {
        this.setUnderlyingTableModel(underlyingTableModel);
        this.columnModel = columnModel;
    }

    public DefaultSortableTableModel(TableColumnModel columnModel) {
        this.columnModel = columnModel;
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    public TableModel getUnderlyingTableModel() {
        return this.underlyingTableModel;
    }

    public void setUnderlyingTableModel(TableModel newTableModel) {
        if (this.underlyingTableModel != null) {
            this.underlyingTableModel.removeTableModelListener(this.tableModelListener);
        }
        this.underlyingTableModel = newTableModel;
        if (this.underlyingTableModel != null) {
            this.underlyingTableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    private boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    private Directive getDirective(int column) {
        Iterator iter = this.sortingColumns.iterator();
        while (iter.hasNext()) {
            Directive directive = (Directive)iter.next();
            if (directive.column != column) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortDirective(int column) {
        return this.getDirective(column).direction;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
    }

    public void setSortDirective(int column, int sortDirective) {
        Directive directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (sortDirective != 0) {
            this.sortingColumns.add(new Directive(column, sortDirective));
        }
        this.sortingStatusChanged();
    }

    private void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class type, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(type);
        } else {
            this.columnComparators.put(type, comparator);
        }
    }

    protected Comparator getComparator(int column) {
        TableColumn tableColumn;
        Comparator comparator;
        Class columnType = null;
        if (this.underlyingTableModel != null) {
            columnType = this.underlyingTableModel.getColumnClass(column);
        }
        if ((comparator = (Comparator)this.columnComparators.get(columnType)) == null && this.columnModel != null && (tableColumn = this.columnModel.getColumn(column)) instanceof SortableTableColumn && ((Object)(comparator = ((SortableTableColumn)tableColumn).getComparator())).equals(SortableTableColumn.DEFAULT_COMPARATOR)) {
            comparator = null;
        }
        if (comparator == null) {
            comparator = Comparable.class.isAssignableFrom(columnType) ? COMPARABLE_COMPARATOR : LEXICAL_COMPARATOR;
        }
        return comparator;
    }

    private SortedRow[] getViewToModelSortedRows() {
        if (this.viewToModel == null) {
            int tableModelRowCount = 0;
            if (this.underlyingTableModel != null) {
                tableModelRowCount = this.underlyingTableModel.getRowCount();
            }
            this.viewToModel = new SortedRow[tableModelRowCount];
            for (int row = 0; row < tableModelRowCount; ++row) {
                this.viewToModel[row] = new SortedRow(row);
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    public int toUnsortedModelRowIndex(int viewRowIndex) {
        if (viewRowIndex == -1) {
            return -1;
        }
        SortedRow[] viewToModel = this.getViewToModelSortedRows();
        if (viewToModel != null && viewRowIndex < viewToModel.length) {
            return viewToModel[viewRowIndex].modelIndex;
        }
        return viewRowIndex;
    }

    private int[] getModelToViewSortedRows() {
        if (this.modelToView == null) {
            int n = this.getViewToModelSortedRows().length;
            this.modelToView = new int[n];
            for (int i = 0; i < n; ++i) {
                this.modelToView[this.toUnsortedModelRowIndex((int)i)] = i;
            }
        }
        return this.modelToView;
    }

    public int toSortedViewRowIndex(int modelRowIndex) {
        int[] modelToView = this.getModelToViewSortedRows();
        if (modelToView != null && modelRowIndex < modelToView.length) {
            return modelToView[modelRowIndex];
        }
        return modelRowIndex;
    }

    public int getRowCount() {
        return this.underlyingTableModel == null ? 0 : this.underlyingTableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.underlyingTableModel == null ? 0 : this.underlyingTableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.underlyingTableModel == null ? null : this.underlyingTableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.underlyingTableModel == null ? null : this.underlyingTableModel.getColumnClass(column);
    }

    public Object getValueAt(int column, int row) {
        return this.underlyingTableModel == null ? null : this.underlyingTableModel.getValueAt(column, this.toUnsortedModelRowIndex(row));
    }

    public void sortByColumn(int column, int sortDirective) {
        this.setSortDirective(column, sortDirective);
    }

    public int getCurrentSortColumn() {
        int sortColumn = -1;
        if (this.sortingColumns.size() > 0) {
            Directive directive = (Directive)this.sortingColumns.get(this.sortingColumns.size() - 1);
            sortColumn = directive.column;
        }
        return sortColumn;
    }

    private static class Directive {
        private int column;
        private int direction;

        public Directive(int column, int direction) {
            this.column = column;
            this.direction = direction;
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent e) {
            if (!DefaultSortableTableModel.this.isSorting()) {
                DefaultSortableTableModel.this.clearSortingState();
                DefaultSortableTableModel.this.fireTableChanged(e);
                return;
            }
            if (e.getFirstRow() == -1) {
                DefaultSortableTableModel.this.cancelSorting();
                DefaultSortableTableModel.this.fireTableChanged(e);
                return;
            }
            int column = e.getColumn();
            int sortStatus = DefaultSortableTableModel.this.getSortDirective(column);
            if (e.getFirstRow() == e.getLastRow() && column != -2 && sortStatus == 0 && DefaultSortableTableModel.this.modelToView != null) {
                int viewIndex = DefaultSortableTableModel.this.getModelToViewSortedRows()[e.getFirstRow()];
                DefaultSortableTableModel.this.fireTableChanged(new TableModelEvent((TableModel)DefaultSortableTableModel.this, viewIndex, viewIndex, column, e.getType()));
                return;
            }
            DefaultSortableTableModel.this.clearSortingState();
            DefaultSortableTableModel.this.fireTableDataChanged();
        }
    }

    private class SortedRow
    implements Comparable {
        private int modelIndex;

        public SortedRow(int index) {
            this.modelIndex = index;
        }

        public int compareTo(Object o) {
            int row1 = this.modelIndex;
            int row2 = ((SortedRow)o).modelIndex;
            int tableColCount = DefaultSortableTableModel.this.underlyingTableModel == null ? -1 : DefaultSortableTableModel.this.underlyingTableModel.getColumnCount();
            for (int i = DefaultSortableTableModel.this.sortingColumns.size() - 1; i >= 0; --i) {
                Directive directive = (Directive)DefaultSortableTableModel.this.sortingColumns.get(i);
                int column = directive.column;
                if (column < 0 || column >= tableColCount) continue;
                Object o1 = DefaultSortableTableModel.this.underlyingTableModel.getValueAt(column, row1);
                Object o2 = DefaultSortableTableModel.this.underlyingTableModel.getValueAt(column, row2);
                int comparison = 0;
                comparison = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : DefaultSortableTableModel.this.getComparator(column).compare(o1, o2)));
                if (comparison == 0) continue;
                return directive.direction == -1 ? -comparison : comparison;
            }
            return 0;
        }
    }
}

