/*
 * Decompiled with CFR 0.152.
 */
package echopointng.text;

import echopointng.AutoLookupTextFieldEx;
import echopointng.EPNG;
import echopointng.text.AutoLookupModel;
import echopointng.util.HtmlKit;
import echopointng.xhtml.XhtmlFragment;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.ServiceRegistry;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AutoLookupService
implements Service {
    public static final AutoLookupService INSTANCE = new AutoLookupService();
    private Map interestedParties = new HashMap();

    public String getId() {
        return "EPNG.AutoLookup";
    }

    public int getVersion() {
        return -1;
    }

    public synchronized void register(AutoLookupTextFieldEx textFieldEx) {
        this.interestedParties.put("c_" + textFieldEx.getRenderId(), textFieldEx);
    }

    public synchronized void deregister(AutoLookupTextFieldEx textFieldEx) {
        this.interestedParties.remove("c_" + textFieldEx.getRenderId());
    }

    public void service(Connection conn) throws IOException {
        HttpServletRequest request = conn.getRequest();
        String elementId = request.getParameter("elementId");
        String searchValue = request.getParameter("searchValue");
        AutoLookupTextFieldEx textFieldEx = (AutoLookupTextFieldEx)this.interestedParties.get(elementId);
        if (textFieldEx == null) {
            throw new IllegalStateException("The TextFieldEx " + elementId + " could not be found.");
        }
        AutoLookupModel autoLookupModel = (AutoLookupModel)AutoLookupService.getRP((Component)textFieldEx, "autoLookupModel");
        if (autoLookupModel == null) {
            return;
        }
        XmlDocument xmlDocument = new XmlDocument("data", null, null, "http://www.w3.org/1999/xhtml");
        Document doc = xmlDocument.getDocument();
        Element dataElement = doc.getDocumentElement();
        Element autoLookupModelE = doc.createElement("autoLookupModel");
        AutoLookupModel.Entry[] entries = autoLookupModel.searchEntries(searchValue, autoLookupModel.getMatchOptions());
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                Element entryE = AutoLookupService.createEntryXml(doc, entries[i]);
                autoLookupModelE.appendChild(entryE);
            }
        }
        dataElement.appendChild(autoLookupModelE);
        conn.setContentType(ContentType.TEXT_XML);
        PrintWriter out = conn.getWriter();
        xmlDocument.render(out);
    }

    public static Element createEntryXml(Document document, AutoLookupModel.Entry entry) {
        String value = entry.getValue();
        String sortValue = entry.getSortValue();
        XhtmlFragment xhtmlFrag = entry.getXhtmlFragment();
        String xhtml = xhtmlFrag == null ? value : xhtmlFrag.toString();
        sortValue = sortValue != null ? sortValue : value;
        value = HtmlKit.encode(value);
        sortValue = HtmlKit.encode(sortValue);
        xhtml = HtmlKit.encode(xhtml);
        Element valueE = document.createElement("value");
        valueE.appendChild(document.createCDATASection(value));
        Element sortValueE = document.createElement("sortValue");
        sortValueE.appendChild(document.createCDATASection(sortValue));
        Element xhtmlE = document.createElement("xhtml");
        xhtmlE.appendChild(document.createCDATASection(xhtml.toString()));
        Element entryE = document.createElement("entry");
        entryE.appendChild(valueE);
        entryE.appendChild(sortValueE);
        entryE.appendChild(xhtmlE);
        return entryE;
    }

    private static Object getRP(Component component, String propertyName) {
        Style style;
        Object value = component.getRenderProperty(propertyName);
        if (value == null && (style = EPNG.getFallBackStyle(component)) != null) {
            value = style.getProperty(propertyName);
        }
        return value;
    }

    static {
        ServiceRegistry serviceRegistry = WebRenderServlet.getServiceRegistry();
        serviceRegistry.add((Service)INSTANCE);
    }
}

