/*
 * Decompiled with CFR 0.152.
 */
package echopointng.tree;

import java.io.Serializable;
import java.util.BitSet;
import java.util.EventListener;
import javax.swing.event.ListSelectionListener;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;
import nextapp.echo2.app.event.EventListenerList;
import nextapp.echo2.app.list.ListSelectionModel;

public class TreeListSelectionModel
implements ListSelectionModel,
Serializable {
    public static final int SINGLE_SELECTION = 1;
    public static final int SINGLE_INTERVAL_SELECTION = 2;
    public static final int MULTIPLE_INTERVAL_SELECTION = 4;
    private static final int MIN = -1;
    private static final int MAX = Integer.MAX_VALUE;
    private int selectionMode = 4;
    private int minIndex = Integer.MAX_VALUE;
    private int maxIndex = -1;
    private int anchorIndex = -1;
    private int leadIndex = -1;
    private int firstAdjustedIndex = Integer.MAX_VALUE;
    private int lastAdjustedIndex = -1;
    private boolean isAdjusting = false;
    private int firstChangedIndex = Integer.MAX_VALUE;
    private int lastChangedIndex = -1;
    private BitSet value = new BitSet(32);
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean leadAnchorNotificationEnabled = true;

    public void addChangeListener(ChangeListener l) {
        this.listenerList.addListener(ChangeListener.class, (EventListener)l);
    }

    public void addSelectionInterval(int index0, int index1) {
        if (index0 == -1 || index1 == -1) {
            return;
        }
        if (this.getSelectionMode() != 4) {
            this.setSelectionInterval(index0, index1);
            return;
        }
        this.updateLeadAnchorIndices(index0, index1);
        int clearMin = Integer.MAX_VALUE;
        int clearMax = -1;
        int setMin = Math.min(index0, index1);
        int setMax = Math.max(index0, index1);
        this.changeSelection(clearMin, clearMax, setMin, setMax);
    }

    private void changeSelection(int clearMin, int clearMax, int setMin, int setMax) {
        this.changeSelection(clearMin, clearMax, setMin, setMax, true);
    }

    private void changeSelection(int clearMin, int clearMax, int setMin, int setMax, boolean clearFirst) {
        for (int i = Math.min(setMin, clearMin); i <= Math.max(setMax, clearMax); ++i) {
            boolean shouldClear = this.contains(clearMin, clearMax, i);
            boolean shouldSet = this.contains(setMin, setMax, i);
            if (shouldSet && shouldClear) {
                if (clearFirst) {
                    shouldClear = false;
                } else {
                    shouldSet = false;
                }
            }
            if (shouldSet) {
                this.set(i);
            }
            if (!shouldClear) continue;
            this.clear(i);
        }
        this.fireValueChanged();
    }

    private void clear(int r) {
        if (!this.value.get(r)) {
            return;
        }
        this.value.clear(r);
        this.markAsDirty(r);
        if (r == this.minIndex) {
            ++this.minIndex;
            while (this.minIndex <= this.maxIndex && !this.value.get(this.minIndex)) {
                ++this.minIndex;
            }
        }
        if (r == this.maxIndex) {
            --this.maxIndex;
            while (this.minIndex <= this.maxIndex && !this.value.get(this.maxIndex)) {
                --this.maxIndex;
            }
        }
        if (this.isSelectionEmpty()) {
            this.minIndex = Integer.MAX_VALUE;
            this.maxIndex = -1;
        }
    }

    public void clearSelection() {
        this.removeSelectionInterval(this.minIndex, this.maxIndex);
    }

    private boolean contains(int a, int b, int i) {
        return i >= a && i <= b;
    }

    private void fireValueChanged() {
        if (this.lastAdjustedIndex == -1) {
            return;
        }
        if (this.getValueIsAdjusting()) {
            this.firstChangedIndex = Math.min(this.firstChangedIndex, this.firstAdjustedIndex);
            this.lastChangedIndex = Math.max(this.lastChangedIndex, this.lastAdjustedIndex);
        }
        int oldFirstAdjustedIndex = this.firstAdjustedIndex;
        int oldLastAdjustedIndex = this.lastAdjustedIndex;
        this.firstAdjustedIndex = Integer.MAX_VALUE;
        this.lastAdjustedIndex = -1;
        this.fireValueChanged(oldFirstAdjustedIndex, oldLastAdjustedIndex);
    }

    protected void fireValueChanged(int firstIndex, int lastIndex) {
        this.fireValueChanged(firstIndex, lastIndex, this.getValueIsAdjusting());
    }

    protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        ChangeEvent e = null;
        EventListener[] listeners = this.listenerList.getListeners(ListSelectionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ChangeEvent((Object)this);
            }
            ((ChangeListener)listeners[i]).stateChanged(e);
        }
    }

    protected void fireValueChanged(boolean isAdjusting) {
        if (this.lastChangedIndex == -1) {
            return;
        }
        int oldFirstChangedIndex = this.firstChangedIndex;
        int oldLastChangedIndex = this.lastChangedIndex;
        this.firstChangedIndex = Integer.MAX_VALUE;
        this.lastChangedIndex = -1;
        this.fireValueChanged(oldFirstChangedIndex, oldLastChangedIndex, isAdjusting);
    }

    public int getAnchorSelectionIndex() {
        return this.anchorIndex;
    }

    public int getLeadSelectionIndex() {
        return this.leadIndex;
    }

    public int getMaxSelectedIndex() {
        return this.maxIndex;
    }

    public int getMinSelectedIndex() {
        return this.isSelectionEmpty() ? -1 : this.minIndex;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void insertIndexInterval(int index, int length, boolean before) {
        int insMinIndex = before ? index : index + 1;
        int insMaxIndex = insMinIndex + length - 1;
        for (int i = this.maxIndex; i >= insMinIndex; --i) {
            this.setState(i + length, this.value.get(i));
        }
        boolean setInsertedValues = this.value.get(index);
        for (int i = insMinIndex; i <= insMaxIndex; ++i) {
            this.setState(i, setInsertedValues);
        }
    }

    public boolean isLeadAnchorNotificationEnabled() {
        return this.leadAnchorNotificationEnabled;
    }

    public boolean isSelectedIndex(int index) {
        return index < this.minIndex || index > this.maxIndex ? false : this.value.get(index);
    }

    public boolean isSelectionEmpty() {
        return this.minIndex > this.maxIndex;
    }

    private void markAsDirty(int r) {
        this.firstAdjustedIndex = Math.min(this.firstAdjustedIndex, r);
        this.lastAdjustedIndex = Math.max(this.lastAdjustedIndex, r);
    }

    public void removeIndexInterval(int index0, int index1) {
        int rmMinIndex = Math.min(index0, index1);
        int rmMaxIndex = Math.max(index0, index1);
        int gapLength = rmMaxIndex - rmMinIndex + 1;
        for (int i = rmMinIndex; i <= this.maxIndex; ++i) {
            this.setState(i, this.value.get(i + gapLength));
        }
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.removeListener(ChangeListener.class, (EventListener)l);
    }

    public void removeSelectionInterval(int index0, int index1) {
        if (index0 == -1 || index1 == -1) {
            return;
        }
        this.updateLeadAnchorIndices(index0, index1);
        int clearMin = Math.min(index0, index1);
        int clearMax = Math.max(index0, index1);
        int setMin = Integer.MAX_VALUE;
        int setMax = -1;
        if (this.getSelectionMode() != 4 && clearMin > this.minIndex && clearMax < this.maxIndex) {
            clearMax = this.maxIndex;
        }
        this.changeSelection(clearMin, clearMax, setMin, setMax);
    }

    private void set(int r) {
        if (this.value.get(r)) {
            return;
        }
        this.value.set(r);
        this.markAsDirty(r);
        this.minIndex = Math.min(this.minIndex, r);
        this.maxIndex = Math.max(this.maxIndex, r);
    }

    public void setAnchorSelectionIndex(int anchorIndex) {
        this.updateLeadAnchorIndices(anchorIndex, this.leadIndex);
        this.anchorIndex = anchorIndex;
        this.fireValueChanged();
    }

    public void setLeadAnchorNotificationEnabled(boolean flag) {
        this.leadAnchorNotificationEnabled = flag;
    }

    public void setLeadSelectionIndex(int leadIndex) {
        int anchorIndex = this.anchorIndex;
        if (anchorIndex == -1 || leadIndex == -1) {
            return;
        }
        if (this.leadIndex == -1) {
            this.leadIndex = leadIndex;
        }
        if (this.getSelectionMode() == 1) {
            anchorIndex = leadIndex;
        }
        int oldMin = Math.min(this.anchorIndex, this.leadIndex);
        int oldMax = Math.max(this.anchorIndex, this.leadIndex);
        int newMin = Math.min(anchorIndex, leadIndex);
        int newMax = Math.max(anchorIndex, leadIndex);
        if (this.value.get(this.anchorIndex)) {
            this.changeSelection(oldMin, oldMax, newMin, newMax);
        } else {
            this.changeSelection(newMin, newMax, oldMin, oldMax, false);
        }
        this.anchorIndex = anchorIndex;
        this.leadIndex = leadIndex;
    }

    public void setSelectedIndex(int index, boolean selected) {
        this.setSelectionInterval(index, index);
    }

    public void setSelectionInterval(int index0, int index1) {
        if (index0 == -1 || index1 == -1) {
            return;
        }
        if (this.getSelectionMode() == 1) {
            index0 = index1;
        }
        this.updateLeadAnchorIndices(index0, index1);
        int clearMin = this.minIndex;
        int clearMax = this.maxIndex;
        int setMin = Math.min(index0, index1);
        int setMax = Math.max(index0, index1);
        this.changeSelection(clearMin, clearMax, setMin, setMax);
    }

    public void setSelectionMode(int selectionMode) {
        switch (selectionMode) {
            case 1: 
            case 2: 
            case 4: {
                this.selectionMode = selectionMode;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid selectionMode");
            }
        }
    }

    private void setState(int index, boolean state) {
        if (state) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    public void setValueIsAdjusting(boolean isAdjusting) {
        if (isAdjusting != this.isAdjusting) {
            this.isAdjusting = isAdjusting;
            this.fireValueChanged(isAdjusting);
        }
    }

    public String toString() {
        String s = (this.getValueIsAdjusting() ? "~" : "=") + this.value.toString();
        return this.getClass().getName() + " " + Integer.toString(this.hashCode()) + " " + s;
    }

    private void updateLeadAnchorIndices(int anchorIndex, int leadIndex) {
        if (this.leadAnchorNotificationEnabled) {
            if (this.anchorIndex != anchorIndex) {
                if (this.anchorIndex != -1) {
                    this.markAsDirty(this.anchorIndex);
                }
                this.markAsDirty(anchorIndex);
            }
            if (this.leadIndex != leadIndex) {
                if (this.leadIndex != -1) {
                    this.markAsDirty(this.leadIndex);
                }
                this.markAsDirty(leadIndex);
            }
        }
        this.anchorIndex = anchorIndex;
        this.leadIndex = leadIndex;
    }
}

